/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.DocumentationPartType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentationPartLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentationPartLocation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentationPartLocation.getter(DocumentationPartLocation::typeAsString)).setter(DocumentationPartLocation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentationPartLocation.getter(DocumentationPartLocation::path)).setter(DocumentationPartLocation.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentationPartLocation.getter(DocumentationPartLocation::method)).setter(DocumentationPartLocation.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentationPartLocation.getter(DocumentationPartLocation::statusCode)).setter(DocumentationPartLocation.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentationPartLocation.getter(DocumentationPartLocation::name)).setter(DocumentationPartLocation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PATH_FIELD, METHOD_FIELD, STATUS_CODE_FIELD, NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String path;
    private final String method;
    private final String statusCodeValue;
    private final String name;

    private DocumentationPartLocation(BuilderImpl builder) {
        this.type = builder.type;
        this.path = builder.path;
        this.method = builder.method;
        this.statusCodeValue = builder.statusCodeValue;
        this.name = builder.name;
    }

    public DocumentationPartType type() {
        return DocumentationPartType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String path() {
        return this.path;
    }

    public String method() {
        return this.method;
    }

    public String statusCode() {
        return this.statusCodeValue;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.method());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentationPartLocation)) {
            return false;
        }
        DocumentationPartLocation other = (DocumentationPartLocation)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.method(), other.method()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"DocumentationPartLocation").add("Type", (Object)this.typeAsString()).add("Path", (Object)this.path()).add("Method", (Object)this.method()).add("StatusCode", (Object)this.statusCode()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "method": {
                return Optional.ofNullable(clazz.cast(this.method()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentationPartLocation, T> g) {
        return obj -> g.apply((DocumentationPartLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String path;
        private String method;
        private String statusCodeValue;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentationPartLocation model) {
            this.type(model.type);
            this.path(model.path);
            this.method(model.method);
            this.statusCode(model.statusCodeValue);
            this.name(model.name);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentationPartType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getMethod() {
            return this.method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public DocumentationPartLocation build() {
            return new DocumentationPartLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentationPartLocation> {
        public Builder type(String var1);

        public Builder type(DocumentationPartType var1);

        public Builder path(String var1);

        public Builder method(String var1);

        public Builder statusCode(String var1);

        public Builder name(String var1);
    }
}

