/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A single patch operation to apply to the specified resource. Please refer to
 * http://tools.ietf.org/html/rfc6902#section-4 for an explanation of how each operation is used.
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatchOperation implements SdkPojo, Serializable, ToCopyableBuilder<PatchOperation.Builder, PatchOperation> {
    private static final SdkField<String> OP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PatchOperation::opAsString)).setter(setter(Builder::op))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("op").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PatchOperation::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PatchOperation::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PatchOperation::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OP_FIELD, PATH_FIELD,
            VALUE_FIELD, FROM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String op;

    private final String path;

    private final String value;

    private final String from;

    private PatchOperation(BuilderImpl builder) {
        this.op = builder.op;
        this.path = builder.path;
        this.value = builder.value;
        this.from = builder.from;
    }

    /**
     * <p>
     * An update operation to be performed with this PATCH request. The valid value can be <code>add</code>,
     * <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a
     * given resource. Support of the operations depends on specific operational contexts. Attempts to apply an
     * unsupported operation on a resource will return an error message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #op} will return
     * {@link Op#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #opAsString}.
     * </p>
     * 
     * @return An update operation to be performed with this PATCH request. The valid value can be <code>add</code>,
     *         <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported
     *         for a given resource. Support of the operations depends on specific operational contexts. Attempts to
     *         apply an unsupported operation on a resource will return an error message.
     * @see Op
     */
    public Op op() {
        return Op.fromValue(op);
    }

    /**
     * <p>
     * An update operation to be performed with this PATCH request. The valid value can be <code>add</code>,
     * <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a
     * given resource. Support of the operations depends on specific operational contexts. Attempts to apply an
     * unsupported operation on a resource will return an error message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #op} will return
     * {@link Op#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #opAsString}.
     * </p>
     * 
     * @return An update operation to be performed with this PATCH request. The valid value can be <code>add</code>,
     *         <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported
     *         for a given resource. Support of the operations depends on specific operational contexts. Attempts to
     *         apply an unsupported operation on a resource will return an error message.
     * @see Op
     */
    public String opAsString() {
        return op;
    }

    /**
     * <p>
     * The <code>op</code> operation's target, as identified by a <a
     * href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that references a
     * location within the targeted resource. For example, if the target resource has an updateable property of
     * <code>{"name":"value"}</code>, the path for this property is <code>/name</code>. If the <code>name</code>
     * property value is a JSON object (e.g., <code>{"name": {"child/name": "child-value"}}</code>), the path for the
     * <code>child/name</code> property will be <code>/name/child~1name</code>. Any slash ("/") character appearing in
     * path names must be escaped with "~1", as shown in the example above. Each <code>op</code> operation can have only
     * one <code>path</code> associated with it.
     * </p>
     * 
     * @return The <code>op</code> operation's target, as identified by a <a
     *         href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that
     *         references a location within the targeted resource. For example, if the target resource has an updateable
     *         property of <code>{"name":"value"}</code>, the path for this property is <code>/name</code>. If the
     *         <code>name</code> property value is a JSON object (e.g.,
     *         <code>{"name": {"child/name": "child-value"}}</code>), the path for the <code>child/name</code> property
     *         will be <code>/name/child~1name</code>. Any slash ("/") character appearing in path names must be escaped
     *         with "~1", as shown in the example above. Each <code>op</code> operation can have only one
     *         <code>path</code> associated with it.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The new target value of the update operation. It is applicable for the <code>add</code> or <code>replace</code>
     * operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single
     * quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for
     * Parameters</a>.
     * </p>
     * 
     * @return The new target value of the update operation. It is applicable for the <code>add</code> or
     *         <code>replace</code> operation. When using AWS CLI to update a property of a JSON value, enclose the JSON
     *         object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a
     *         href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using
     *         JSON for Parameters</a>.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The <code>copy</code> update operation's source as identified by a <code>JSON-Pointer</code> value referencing
     * the location within the targeted resource to copy the value from. For example, to promote a canary deployment,
     * you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a <a>Stage</a>
     * resource with <code>"op":"copy"</code>, <code>"from":"/canarySettings/deploymentId"</code> and
     * <code>"path":"/deploymentId"</code>.
     * </p>
     * 
     * @return The <code>copy</code> update operation's source as identified by a <code>JSON-Pointer</code> value
     *         referencing the location within the targeted resource to copy the value from. For example, to promote a
     *         canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH
     *         request on a <a>Stage</a> resource with <code>"op":"copy"</code>,
     *         <code>"from":"/canarySettings/deploymentId"</code> and <code>"path":"/deploymentId"</code>.
     */
    public String from() {
        return from;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchOperation)) {
            return false;
        }
        PatchOperation other = (PatchOperation) obj;
        return Objects.equals(opAsString(), other.opAsString()) && Objects.equals(path(), other.path())
                && Objects.equals(value(), other.value()) && Objects.equals(from(), other.from());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PatchOperation").add("Op", opAsString()).add("Path", path()).add("Value", value())
                .add("From", from()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "op":
            return Optional.ofNullable(clazz.cast(opAsString()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchOperation, T> g) {
        return obj -> g.apply((PatchOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatchOperation> {
        /**
         * <p>
         * An update operation to be performed with this PATCH request. The valid value can be <code>add</code>,
         * <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a
         * given resource. Support of the operations depends on specific operational contexts. Attempts to apply an
         * unsupported operation on a resource will return an error message.
         * </p>
         * 
         * @param op
         *        An update operation to be performed with this PATCH request. The valid value can be <code>add</code>,
         *        <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported
         *        for a given resource. Support of the operations depends on specific operational contexts. Attempts to
         *        apply an unsupported operation on a resource will return an error message.
         * @see Op
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Op
         */
        Builder op(String op);

        /**
         * <p>
         * An update operation to be performed with this PATCH request. The valid value can be <code>add</code>,
         * <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a
         * given resource. Support of the operations depends on specific operational contexts. Attempts to apply an
         * unsupported operation on a resource will return an error message.
         * </p>
         * 
         * @param op
         *        An update operation to be performed with this PATCH request. The valid value can be <code>add</code>,
         *        <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported
         *        for a given resource. Support of the operations depends on specific operational contexts. Attempts to
         *        apply an unsupported operation on a resource will return an error message.
         * @see Op
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Op
         */
        Builder op(Op op);

        /**
         * <p>
         * The <code>op</code> operation's target, as identified by a <a
         * href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that references
         * a location within the targeted resource. For example, if the target resource has an updateable property of
         * <code>{"name":"value"}</code>, the path for this property is <code>/name</code>. If the <code>name</code>
         * property value is a JSON object (e.g., <code>{"name": {"child/name": "child-value"}}</code>), the path for
         * the <code>child/name</code> property will be <code>/name/child~1name</code>. Any slash ("/") character
         * appearing in path names must be escaped with "~1", as shown in the example above. Each <code>op</code>
         * operation can have only one <code>path</code> associated with it.
         * </p>
         * 
         * @param path
         *        The <code>op</code> operation's target, as identified by a <a
         *        href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that
         *        references a location within the targeted resource. For example, if the target resource has an
         *        updateable property of <code>{"name":"value"}</code>, the path for this property is <code>/name</code>
         *        . If the <code>name</code> property value is a JSON object (e.g.,
         *        <code>{"name": {"child/name": "child-value"}}</code>), the path for the <code>child/name</code>
         *        property will be <code>/name/child~1name</code>. Any slash ("/") character appearing in path names
         *        must be escaped with "~1", as shown in the example above. Each <code>op</code> operation can have only
         *        one <code>path</code> associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The new target value of the update operation. It is applicable for the <code>add</code> or
         * <code>replace</code> operation. When using AWS CLI to update a property of a JSON value, enclose the JSON
         * object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see <a
         * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON
         * for Parameters</a>.
         * </p>
         * 
         * @param value
         *        The new target value of the update operation. It is applicable for the <code>add</code> or
         *        <code>replace</code> operation. When using AWS CLI to update a property of a JSON value, enclose the
         *        JSON object with a pair of single quotes in a Linux shell, e.g., '{"a": ...}'. In a Windows shell, see
         *        <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">
         *        Using JSON for Parameters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The <code>copy</code> update operation's source as identified by a <code>JSON-Pointer</code> value
         * referencing the location within the targeted resource to copy the value from. For example, to promote a
         * canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH
         * request on a <a>Stage</a> resource with <code>"op":"copy"</code>,
         * <code>"from":"/canarySettings/deploymentId"</code> and <code>"path":"/deploymentId"</code>.
         * </p>
         * 
         * @param from
         *        The <code>copy</code> update operation's source as identified by a <code>JSON-Pointer</code> value
         *        referencing the location within the targeted resource to copy the value from. For example, to promote
         *        a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a
         *        PATCH request on a <a>Stage</a> resource with <code>"op":"copy"</code>,
         *        <code>"from":"/canarySettings/deploymentId"</code> and <code>"path":"/deploymentId"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);
    }

    static final class BuilderImpl implements Builder {
        private String op;

        private String path;

        private String value;

        private String from;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchOperation model) {
            op(model.op);
            path(model.path);
            value(model.value);
            from(model.from);
        }

        public final String getOp() {
            return op;
        }

        @Override
        public final Builder op(String op) {
            this.op = op;
            return this;
        }

        @Override
        public final Builder op(Op op) {
            this.op(op == null ? null : op.toString());
            return this;
        }

        public final void setOp(String op) {
            this.op = op;
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getFrom() {
            return from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public PatchOperation build() {
            return new PatchOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
