/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GET request to get a usage plan key of a given key identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsagePlanKeyRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetUsagePlanKeyRequest.Builder, GetUsagePlanKeyRequest> {
    private static final SdkField<String> USAGE_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetUsagePlanKeyRequest::usagePlanId)).setter(setter(Builder::usagePlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("usageplanId").build()).build();

    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetUsagePlanKeyRequest::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("keyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_PLAN_ID_FIELD,
            KEY_ID_FIELD));

    private final String usagePlanId;

    private final String keyId;

    private GetUsagePlanKeyRequest(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.keyId = builder.keyId;
    }

    /**
     * <p>
     * [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved
     * <a>UsagePlanKey</a> resource representing a plan customer.
     * </p>
     * 
     * @return [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the
     *         to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
     */
    public String usagePlanId() {
        return usagePlanId;
    }

    /**
     * <p>
     * [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
     * </p>
     * 
     * @return [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
     */
    public String keyId() {
        return keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsagePlanKeyRequest)) {
            return false;
        }
        GetUsagePlanKeyRequest other = (GetUsagePlanKeyRequest) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId()) && Objects.equals(keyId(), other.keyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetUsagePlanKeyRequest").add("UsagePlanId", usagePlanId()).add("KeyId", keyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        case "keyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsagePlanKeyRequest, T> g) {
        return obj -> g.apply((GetUsagePlanKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetUsagePlanKeyRequest> {
        /**
         * <p>
         * [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved
         * <a>UsagePlanKey</a> resource representing a plan customer.
         * </p>
         * 
         * @param usagePlanId
         *        [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the
         *        to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        /**
         * <p>
         * [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
         * </p>
         * 
         * @param keyId
         *        [Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan
         *        customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String usagePlanId;

        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsagePlanKeyRequest model) {
            super(model);
            usagePlanId(model.usagePlanId);
            keyId(model.keyId);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsagePlanKeyRequest build() {
            return new GetUsagePlanKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
