/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to list information about a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetResourceRequest.Builder, GetResourceRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResourceRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()).build();

    private static final SdkField<List<String>> EMBED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetResourceRequest::embed))
            .setter(setter(Builder::embed))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("embed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESOURCE_ID_FIELD, EMBED_FIELD));

    private final String restApiId;

    private final String resourceId;

    private final List<String> embed;

    private GetResourceRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.embed = builder.embed;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The identifier for the <a>Resource</a> resource.
     * </p>
     * 
     * @return [Required] The identifier for the <a>Resource</a> resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * Returns true if the Embed property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEmbed() {
        return embed != null && !(embed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation in
     * the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the
     * request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must
     * be a single-valued list and contain the <code>"methods"</code> string. For example,
     * <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEmbed()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a>
     *         representation in the response. This <code>embed</code> parameter value is a list of comma-separated
     *         strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way.
     *         The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For
     *         example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.
     */
    public List<String> embed() {
        return embed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(embed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceRequest)) {
            return false;
        }
        GetResourceRequest other = (GetResourceRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(embed(), other.embed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetResourceRequest").add("RestApiId", restApiId()).add("ResourceId", resourceId())
                .add("Embed", embed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "embed":
            return Optional.ofNullable(clazz.cast(embed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceRequest, T> g) {
        return obj -> g.apply((GetResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The identifier for the <a>Resource</a> resource.
         * </p>
         * 
         * @param resourceId
         *        [Required] The identifier for the <a>Resource</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation
         * in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the
         * request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value
         * must be a single-valued list and contain the <code>"methods"</code> string. For example,
         * <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.
         * </p>
         * 
         * @param embed
         *        A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a>
         *        representation in the response. This <code>embed</code> parameter value is a list of comma-separated
         *        strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this
         *        way. The query parameter value must be a single-valued list and contain the <code>"methods"</code>
         *        string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embed(Collection<String> embed);

        /**
         * <p>
         * A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation
         * in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the
         * request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value
         * must be a single-valued list and contain the <code>"methods"</code> string. For example,
         * <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.
         * </p>
         * 
         * @param embed
         *        A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a>
         *        representation in the response. This <code>embed</code> parameter value is a list of comma-separated
         *        strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this
         *        way. The query parameter value must be a single-valued list and contain the <code>"methods"</code>
         *        string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embed(String... embed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String resourceId;

        private List<String> embed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceRequest model) {
            super(model);
            restApiId(model.restApiId);
            resourceId(model.resourceId);
            embed(model.embed);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getEmbed() {
            return embed;
        }

        @Override
        public final Builder embed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embed(String... embed) {
            embed(Arrays.asList(embed));
            return this;
        }

        public final void setEmbed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceRequest build() {
            return new GetResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
