/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An immutable representation of a <a>RestApi</a> resource that can be called by users using <a>Stages</a>. A
 * deployment must be associated with a <a>Stage</a> for it to be callable over the Internet.
 * </p>
 * <div class="remarks">To create a deployment, call <code>POST</code> on the <a>Deployments</a> resource of a
 * <a>RestApi</a>. To view, update, or delete a deployment, call <code>GET</code>, <code>PATCH</code>, or
 * <code>DELETE</code> on the specified deployment resource (
 * <code>/restapis/{restapi_id}/deployments/{deployment_id}</code>).</div> <div class="seeAlso"><a>RestApi</a>,
 * <a>Deployments</a>, <a>Stage</a>, <a
 * href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI</a>, <a
 * href="https://aws.amazon.com/tools/">AWS SDKs</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<CreateDeploymentResponse.Builder, CreateDeploymentResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateDeploymentResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Map<String, Map<String, MethodSnapshot>>> API_SUMMARY_FIELD = SdkField
            .<Map<String, Map<String, MethodSnapshot>>> builder(MarshallingType.MAP)
            .getter(getter(CreateDeploymentResponse::apiSummary))
            .setter(setter(Builder::apiSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSummary").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, MethodSnapshot>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<MethodSnapshot> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(MethodSnapshot::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            CREATED_DATE_FIELD, API_SUMMARY_FIELD));

    private final String id;

    private final String description;

    private final Instant createdDate;

    private final Map<String, Map<String, MethodSnapshot>> apiSummary;

    private CreateDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.apiSummary = builder.apiSummary;
    }

    /**
     * <p>
     * The identifier for the deployment resource.
     * </p>
     * 
     * @return The identifier for the deployment resource.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The description for the deployment resource.
     * </p>
     * 
     * @return The description for the deployment resource.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date and time that the deployment resource was created.
     * </p>
     * 
     * @return The date and time that the deployment resource was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * Returns true if the ApiSummary property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasApiSummary() {
        return apiSummary != null && !(apiSummary instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApiSummary()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.
     */
    public Map<String, Map<String, MethodSnapshot>> apiSummary() {
        return apiSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(apiSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentResponse)) {
            return false;
        }
        CreateDeploymentResponse other = (CreateDeploymentResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(apiSummary(), other.apiSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDeploymentResponse").add("Id", id()).add("Description", description())
                .add("CreatedDate", createdDate()).add("ApiSummary", apiSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "apiSummary":
            return Optional.ofNullable(clazz.cast(apiSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentResponse, T> g) {
        return obj -> g.apply((CreateDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentResponse> {
        /**
         * <p>
         * The identifier for the deployment resource.
         * </p>
         * 
         * @param id
         *        The identifier for the deployment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description for the deployment resource.
         * </p>
         * 
         * @param description
         *        The description for the deployment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time that the deployment resource was created.
         * </p>
         * 
         * @param createdDate
         *        The date and time that the deployment resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.
         * </p>
         * 
         * @param apiSummary
         *        A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSummary(Map<String, Map<String, MethodSnapshot>> apiSummary);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String description;

        private Instant createdDate;

        private Map<String, Map<String, MethodSnapshot>> apiSummary = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentResponse model) {
            super(model);
            id(model.id);
            description(model.description);
            createdDate(model.createdDate);
            apiSummary(model.apiSummary);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Map<String, Map<String, MethodSnapshot>> getApiSummary() {
            return apiSummary;
        }

        @Override
        public final Builder apiSummary(Map<String, Map<String, MethodSnapshot>> apiSummary) {
            this.apiSummary = PathToMapOfMethodSnapshotCopier.copy(apiSummary);
            return this;
        }

        public final void setApiSummary(Map<String, Map<String, MethodSnapshot>> apiSummary) {
            this.apiSummary = PathToMapOfMethodSnapshotCopier.copy(apiSummary);
        }

        @Override
        public CreateDeploymentResponse build() {
            return new CreateDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
