/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.RestApi;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RestApiMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final MarshallingInfo<List> WARNINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("warnings").isBinary(false).build();
    private static final MarshallingInfo<List> BINARYMEDIATYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("binaryMediaTypes").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINIMUMCOMPRESSIONSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumCompressionSize").isBinary(false).build();
    private static final MarshallingInfo<String> APIKEYSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeySource").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpointConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policy").isBinary(false).build();
    private static final RestApiMarshaller INSTANCE = new RestApiMarshaller();

    private RestApiMarshaller() {
    }

    public static RestApiMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RestApi restApi, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)restApi, (String)"restApi");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)restApi.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)restApi.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)restApi.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)restApi.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)restApi.version(), VERSION_BINDING);
            protocolMarshaller.marshall(restApi.warnings(), WARNINGS_BINDING);
            protocolMarshaller.marshall(restApi.binaryMediaTypes(), BINARYMEDIATYPES_BINDING);
            protocolMarshaller.marshall((Object)restApi.minimumCompressionSize(), MINIMUMCOMPRESSIONSIZE_BINDING);
            protocolMarshaller.marshall((Object)restApi.apiKeySourceAsString(), APIKEYSOURCE_BINDING);
            protocolMarshaller.marshall((Object)restApi.endpointConfiguration(), ENDPOINTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)restApi.policy(), POLICY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

