/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.Model;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModelMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> SCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("schema").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentType").isBinary(false).build();
    private static final ModelMarshaller INSTANCE = new ModelMarshaller();

    private ModelMarshaller() {
    }

    public static ModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Model model, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)model, (String)"model");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)model.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)model.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)model.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)model.schema(), SCHEMA_BINDING);
            protocolMarshaller.marshall((Object)model.contentType(), CONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

