/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.apigateway.model.Method;
import software.amazon.awssdk.services.apigateway.transform.IntegrationUnmarshaller;
import software.amazon.awssdk.services.apigateway.transform.MethodResponseUnmarshaller;

public class MethodUnmarshaller
implements Unmarshaller<Method, JsonUnmarshallerContext> {
    private static final MethodUnmarshaller INSTANCE = new MethodUnmarshaller();

    public Method unmarshall(JsonUnmarshallerContext context) throws Exception {
        Method.Builder methodBuilder = Method.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("httpMethod", targetDepth)) {
                    context.nextToken();
                    methodBuilder.httpMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("authorizationType", targetDepth)) {
                    context.nextToken();
                    methodBuilder.authorizationType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("authorizerId", targetDepth)) {
                    context.nextToken();
                    methodBuilder.authorizerId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("apiKeyRequired", targetDepth)) {
                    context.nextToken();
                    methodBuilder.apiKeyRequired((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("requestValidatorId", targetDepth)) {
                    context.nextToken();
                    methodBuilder.requestValidatorId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("operationName", targetDepth)) {
                    context.nextToken();
                    methodBuilder.operationName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("requestParameters", targetDepth)) {
                    context.nextToken();
                    methodBuilder.requestParameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Boolean.class)).unmarshall(context));
                }
                if (context.testExpression("requestModels", targetDepth)) {
                    context.nextToken();
                    methodBuilder.requestModels(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("methodResponses", targetDepth)) {
                    context.nextToken();
                    methodBuilder.methodResponses(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)MethodResponseUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("methodIntegration", targetDepth)) {
                    context.nextToken();
                    methodBuilder.methodIntegration(IntegrationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("authorizationScopes", targetDepth)) {
                    context.nextToken();
                    methodBuilder.authorizationScopes(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Method)methodBuilder.build();
    }

    public static MethodUnmarshaller getInstance() {
        return INSTANCE;
    }
}

