/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.MethodSetting;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MethodSettingMarshaller {
    private static final MarshallingInfo<Boolean> METRICSENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricsEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGINGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loggingLevel").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DATATRACEENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataTraceEnabled").isBinary(false).build();
    private static final MarshallingInfo<Integer> THROTTLINGBURSTLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("throttlingBurstLimit").isBinary(false).build();
    private static final MarshallingInfo<Double> THROTTLINGRATELIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("throttlingRateLimit").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CACHINGENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cachingEnabled").isBinary(false).build();
    private static final MarshallingInfo<Integer> CACHETTLINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheTtlInSeconds").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CACHEDATAENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheDataEncrypted").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIREAUTHORIZATIONFORCACHECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requireAuthorizationForCacheControl").isBinary(false).build();
    private static final MarshallingInfo<String> UNAUTHORIZEDCACHECONTROLHEADERSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unauthorizedCacheControlHeaderStrategy").isBinary(false).build();
    private static final MethodSettingMarshaller INSTANCE = new MethodSettingMarshaller();

    private MethodSettingMarshaller() {
    }

    public static MethodSettingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MethodSetting methodSetting, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)methodSetting, (String)"methodSetting");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)methodSetting.metricsEnabled(), METRICSENABLED_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.loggingLevel(), LOGGINGLEVEL_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.dataTraceEnabled(), DATATRACEENABLED_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.throttlingBurstLimit(), THROTTLINGBURSTLIMIT_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.throttlingRateLimit(), THROTTLINGRATELIMIT_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.cachingEnabled(), CACHINGENABLED_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.cacheTtlInSeconds(), CACHETTLINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.cacheDataEncrypted(), CACHEDATAENCRYPTED_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.requireAuthorizationForCacheControl(), REQUIREAUTHORIZATIONFORCACHECONTROL_BINDING);
            protocolMarshaller.marshall((Object)methodSetting.unauthorizedCacheControlHeaderStrategyAsString(), UNAUTHORIZEDCACHECONTROLHEADERSTRATEGY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

