/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.ImportApiKeysRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImportApiKeysRequestModelMarshaller {
    private static final MarshallingInfo<SdkBytes> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("format").isBinary(false).build();
    private static final MarshallingInfo<Boolean> FAILONWARNINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("failonwarnings").isBinary(false).build();
    private static final ImportApiKeysRequestModelMarshaller INSTANCE = new ImportApiKeysRequestModelMarshaller();

    private ImportApiKeysRequestModelMarshaller() {
    }

    public static ImportApiKeysRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportApiKeysRequest importApiKeysRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)importApiKeysRequest), (String)"importApiKeysRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)importApiKeysRequest.body(), BODY_BINDING);
            protocolMarshaller.marshall((Object)importApiKeysRequest.formatAsString(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)importApiKeysRequest.failOnWarnings(), FAILONWARNINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

