/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.GetSdkRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetSdkRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("stage_name").isBinary(false).build();
    private static final MarshallingInfo<String> SDKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("sdk_type").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("parameters").isBinary(false).build();
    private static final GetSdkRequestModelMarshaller INSTANCE = new GetSdkRequestModelMarshaller();

    private GetSdkRequestModelMarshaller() {
    }

    public static GetSdkRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetSdkRequest getSdkRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getSdkRequest), (String)"getSdkRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getSdkRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)getSdkRequest.stageName(), STAGENAME_BINDING);
            protocolMarshaller.marshall((Object)getSdkRequest.sdkType(), SDKTYPE_BINDING);
            protocolMarshaller.marshall(getSdkRequest.parameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

