/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.GetModelRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetModelRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("model_name").isBinary(false).build();
    private static final MarshallingInfo<Boolean> FLATTEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("flatten").isBinary(false).build();
    private static final GetModelRequestModelMarshaller INSTANCE = new GetModelRequestModelMarshaller();

    private GetModelRequestModelMarshaller() {
    }

    public static GetModelRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetModelRequest getModelRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getModelRequest), (String)"getModelRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getModelRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)getModelRequest.modelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)getModelRequest.flatten(), FLATTEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

