/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.GetExportRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetExportRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("stage_name").isBinary(false).build();
    private static final MarshallingInfo<String> EXPORTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("export_type").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("parameters").isBinary(false).build();
    private static final MarshallingInfo<String> ACCEPTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Accept").isBinary(false).build();
    private static final GetExportRequestModelMarshaller INSTANCE = new GetExportRequestModelMarshaller();

    private GetExportRequestModelMarshaller() {
    }

    public static GetExportRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetExportRequest getExportRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getExportRequest), (String)"getExportRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getExportRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)getExportRequest.stageName(), STAGENAME_BINDING);
            protocolMarshaller.marshall((Object)getExportRequest.exportType(), EXPORTTYPE_BINDING);
            protocolMarshaller.marshall(getExportRequest.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)getExportRequest.accepts(), ACCEPTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

