/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.GatewayResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GatewayResponseMarshaller {
    private static final MarshallingInfo<String> RESPONSETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseType").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();
    private static final MarshallingInfo<Map> RESPONSEPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> RESPONSETEMPLATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseTemplates").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DEFAULTRESPONSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultResponse").isBinary(false).build();
    private static final GatewayResponseMarshaller INSTANCE = new GatewayResponseMarshaller();

    private GatewayResponseMarshaller() {
    }

    public static GatewayResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GatewayResponse gatewayResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)gatewayResponse, (String)"gatewayResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)gatewayResponse.responseTypeAsString(), RESPONSETYPE_BINDING);
            protocolMarshaller.marshall((Object)gatewayResponse.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall(gatewayResponse.responseParameters(), RESPONSEPARAMETERS_BINDING);
            protocolMarshaller.marshall(gatewayResponse.responseTemplates(), RESPONSETEMPLATES_BINDING);
            protocolMarshaller.marshall((Object)gatewayResponse.defaultResponse(), DEFAULTRESPONSE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

