/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.CreateResourceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateResourceRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("parent_id").isBinary(false).build();
    private static final MarshallingInfo<String> PATHPART_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pathPart").isBinary(false).build();
    private static final CreateResourceRequestModelMarshaller INSTANCE = new CreateResourceRequestModelMarshaller();

    private CreateResourceRequestModelMarshaller() {
    }

    public static CreateResourceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateResourceRequest createResourceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createResourceRequest), (String)"createResourceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createResourceRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)createResourceRequest.parentId(), PARENTID_BINDING);
            protocolMarshaller.marshall((Object)createResourceRequest.pathPart(), PATHPART_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

