/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateApiKeyRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").isBinary(false).build();
    private static final MarshallingInfo<Boolean> GENERATEDISTINCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("generateDistinctId").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final MarshallingInfo<List> STAGEKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageKeys").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerId").isBinary(false).build();
    private static final CreateApiKeyRequestModelMarshaller INSTANCE = new CreateApiKeyRequestModelMarshaller();

    private CreateApiKeyRequestModelMarshaller() {
    }

    public static CreateApiKeyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateApiKeyRequest createApiKeyRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createApiKeyRequest), (String)"createApiKeyRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createApiKeyRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createApiKeyRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createApiKeyRequest.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)createApiKeyRequest.generateDistinctId(), GENERATEDISTINCTID_BINDING);
            protocolMarshaller.marshall((Object)createApiKeyRequest.value(), VALUE_BINDING);
            protocolMarshaller.marshall(createApiKeyRequest.stageKeys(), STAGEKEYS_BINDING);
            protocolMarshaller.marshall((Object)createApiKeyRequest.customerId(), CUSTOMERID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

