/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.StageKeyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StageKey
implements StructuredPojo,
ToCopyableBuilder<Builder, StageKey> {
    private final String restApiId;
    private final String stageName;

    private StageKey(BuilderImpl builder) {
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String stageName() {
        return this.stageName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageKey)) {
            return false;
        }
        StageKey other = (StageKey)obj;
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stageName(), other.stageName());
    }

    public String toString() {
        return ToString.builder((String)"StageKey").add("RestApiId", (Object)this.restApiId()).add("StageName", (Object)this.stageName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageKeyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String restApiId;
        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(StageKey model) {
            this.restApiId(model.restApiId);
            this.stageName(model.stageName);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public StageKey build() {
            return new StageKey(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StageKey> {
        public Builder restApiId(String var1);

        public Builder stageName(String var1);
    }
}

