/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.QuotaPeriodType;
import software.amazon.awssdk.services.apigateway.transform.QuotaSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuotaSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, QuotaSettings> {
    private final Integer limit;
    private final Integer offset;
    private final String period;

    private QuotaSettings(BuilderImpl builder) {
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.period = builder.period;
    }

    public Integer limit() {
        return this.limit;
    }

    public Integer offset() {
        return this.offset;
    }

    public QuotaPeriodType period() {
        return QuotaPeriodType.fromValue(this.period);
    }

    public String periodAsString() {
        return this.period;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaSettings)) {
            return false;
        }
        QuotaSettings other = (QuotaSettings)obj;
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.periodAsString(), other.periodAsString());
    }

    public String toString() {
        return ToString.builder((String)"QuotaSettings").add("Limit", (Object)this.limit()).add("Offset", (Object)this.offset()).add("Period", (Object)this.periodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QuotaSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer limit;
        private Integer offset;
        private String period;

        private BuilderImpl() {
        }

        private BuilderImpl(QuotaSettings model) {
            this.limit(model.limit);
            this.offset(model.offset);
            this.period(model.period);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        public final String getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(QuotaPeriodType period) {
            this.period(period.toString());
            return this;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        public QuotaSettings build() {
            return new QuotaSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QuotaSettings> {
        public Builder limit(Integer var1);

        public Builder offset(Integer var1);

        public Builder period(String var1);

        public Builder period(QuotaPeriodType var1);
    }
}

