/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.GatewayResponseType;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutGatewayResponseResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, PutGatewayResponseResponse> {
    private final String responseType;
    private final String statusCode;
    private final Map<String, String> responseParameters;
    private final Map<String, String> responseTemplates;
    private final Boolean defaultResponse;

    private PutGatewayResponseResponse(BuilderImpl builder) {
        super(builder);
        this.responseType = builder.responseType;
        this.statusCode = builder.statusCode;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
        this.defaultResponse = builder.defaultResponse;
    }

    public GatewayResponseType responseType() {
        return GatewayResponseType.fromValue(this.responseType);
    }

    public String responseTypeAsString() {
        return this.responseType;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public Map<String, String> responseParameters() {
        return this.responseParameters;
    }

    public Map<String, String> responseTemplates() {
        return this.responseTemplates;
    }

    public Boolean defaultResponse() {
        return this.defaultResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResponse());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGatewayResponseResponse)) {
            return false;
        }
        PutGatewayResponseResponse other = (PutGatewayResponseResponse)((Object)obj);
        return Objects.equals(this.responseTypeAsString(), other.responseTypeAsString()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.responseTemplates(), other.responseTemplates()) && Objects.equals(this.defaultResponse(), other.defaultResponse());
    }

    public String toString() {
        return ToString.builder((String)"PutGatewayResponseResponse").add("ResponseType", (Object)this.responseTypeAsString()).add("StatusCode", (Object)this.statusCode()).add("ResponseParameters", this.responseParameters()).add("ResponseTemplates", this.responseTemplates()).add("DefaultResponse", (Object)this.defaultResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "responseType": {
                return Optional.ofNullable(clazz.cast(this.responseTypeAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "responseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "responseTemplates": {
                return Optional.ofNullable(clazz.cast(this.responseTemplates()));
            }
            case "defaultResponse": {
                return Optional.ofNullable(clazz.cast(this.defaultResponse()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String responseType;
        private String statusCode;
        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();
        private Boolean defaultResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(PutGatewayResponseResponse model) {
            super(model);
            this.responseType(model.responseType);
            this.statusCode(model.statusCode);
            this.responseParameters(model.responseParameters);
            this.responseTemplates(model.responseTemplates);
            this.defaultResponse(model.defaultResponse);
        }

        public final String getResponseType() {
            return this.responseType;
        }

        @Override
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public final Builder responseType(GatewayResponseType responseType) {
            this.responseType(responseType.toString());
            return this;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final Map<String, String> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseTemplates() {
            return this.responseTemplates;
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        public final Boolean getDefaultResponse() {
            return this.defaultResponse;
        }

        @Override
        public final Builder defaultResponse(Boolean defaultResponse) {
            this.defaultResponse = defaultResponse;
            return this;
        }

        public final void setDefaultResponse(Boolean defaultResponse) {
            this.defaultResponse = defaultResponse;
        }

        @Override
        public PutGatewayResponseResponse build() {
            return new PutGatewayResponseResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, PutGatewayResponseResponse> {
        public Builder responseType(String var1);

        public Builder responseType(GatewayResponseType var1);

        public Builder statusCode(String var1);

        public Builder responseParameters(Map<String, String> var1);

        public Builder responseTemplates(Map<String, String> var1);

        public Builder defaultResponse(Boolean var1);
    }
}

