/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy;
import software.amazon.awssdk.services.apigateway.transform.MethodSettingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MethodSetting
implements StructuredPojo,
ToCopyableBuilder<Builder, MethodSetting> {
    private final Boolean metricsEnabled;
    private final String loggingLevel;
    private final Boolean dataTraceEnabled;
    private final Integer throttlingBurstLimit;
    private final Double throttlingRateLimit;
    private final Boolean cachingEnabled;
    private final Integer cacheTtlInSeconds;
    private final Boolean cacheDataEncrypted;
    private final Boolean requireAuthorizationForCacheControl;
    private final String unauthorizedCacheControlHeaderStrategy;

    private MethodSetting(BuilderImpl builder) {
        this.metricsEnabled = builder.metricsEnabled;
        this.loggingLevel = builder.loggingLevel;
        this.dataTraceEnabled = builder.dataTraceEnabled;
        this.throttlingBurstLimit = builder.throttlingBurstLimit;
        this.throttlingRateLimit = builder.throttlingRateLimit;
        this.cachingEnabled = builder.cachingEnabled;
        this.cacheTtlInSeconds = builder.cacheTtlInSeconds;
        this.cacheDataEncrypted = builder.cacheDataEncrypted;
        this.requireAuthorizationForCacheControl = builder.requireAuthorizationForCacheControl;
        this.unauthorizedCacheControlHeaderStrategy = builder.unauthorizedCacheControlHeaderStrategy;
    }

    public Boolean metricsEnabled() {
        return this.metricsEnabled;
    }

    public String loggingLevel() {
        return this.loggingLevel;
    }

    public Boolean dataTraceEnabled() {
        return this.dataTraceEnabled;
    }

    public Integer throttlingBurstLimit() {
        return this.throttlingBurstLimit;
    }

    public Double throttlingRateLimit() {
        return this.throttlingRateLimit;
    }

    public Boolean cachingEnabled() {
        return this.cachingEnabled;
    }

    public Integer cacheTtlInSeconds() {
        return this.cacheTtlInSeconds;
    }

    public Boolean cacheDataEncrypted() {
        return this.cacheDataEncrypted;
    }

    public Boolean requireAuthorizationForCacheControl() {
        return this.requireAuthorizationForCacheControl;
    }

    public UnauthorizedCacheControlHeaderStrategy unauthorizedCacheControlHeaderStrategy() {
        return UnauthorizedCacheControlHeaderStrategy.fromValue(this.unauthorizedCacheControlHeaderStrategy);
    }

    public String unauthorizedCacheControlHeaderStrategyAsString() {
        return this.unauthorizedCacheControlHeaderStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTraceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.throttlingBurstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.throttlingRateLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheTtlInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheDataEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireAuthorizationForCacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.unauthorizedCacheControlHeaderStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodSetting)) {
            return false;
        }
        MethodSetting other = (MethodSetting)obj;
        return Objects.equals(this.metricsEnabled(), other.metricsEnabled()) && Objects.equals(this.loggingLevel(), other.loggingLevel()) && Objects.equals(this.dataTraceEnabled(), other.dataTraceEnabled()) && Objects.equals(this.throttlingBurstLimit(), other.throttlingBurstLimit()) && Objects.equals(this.throttlingRateLimit(), other.throttlingRateLimit()) && Objects.equals(this.cachingEnabled(), other.cachingEnabled()) && Objects.equals(this.cacheTtlInSeconds(), other.cacheTtlInSeconds()) && Objects.equals(this.cacheDataEncrypted(), other.cacheDataEncrypted()) && Objects.equals(this.requireAuthorizationForCacheControl(), other.requireAuthorizationForCacheControl()) && Objects.equals(this.unauthorizedCacheControlHeaderStrategyAsString(), other.unauthorizedCacheControlHeaderStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"MethodSetting").add("MetricsEnabled", (Object)this.metricsEnabled()).add("LoggingLevel", (Object)this.loggingLevel()).add("DataTraceEnabled", (Object)this.dataTraceEnabled()).add("ThrottlingBurstLimit", (Object)this.throttlingBurstLimit()).add("ThrottlingRateLimit", (Object)this.throttlingRateLimit()).add("CachingEnabled", (Object)this.cachingEnabled()).add("CacheTtlInSeconds", (Object)this.cacheTtlInSeconds()).add("CacheDataEncrypted", (Object)this.cacheDataEncrypted()).add("RequireAuthorizationForCacheControl", (Object)this.requireAuthorizationForCacheControl()).add("UnauthorizedCacheControlHeaderStrategy", (Object)this.unauthorizedCacheControlHeaderStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.metricsEnabled()));
            }
            case "loggingLevel": {
                return Optional.ofNullable(clazz.cast(this.loggingLevel()));
            }
            case "dataTraceEnabled": {
                return Optional.ofNullable(clazz.cast(this.dataTraceEnabled()));
            }
            case "throttlingBurstLimit": {
                return Optional.ofNullable(clazz.cast(this.throttlingBurstLimit()));
            }
            case "throttlingRateLimit": {
                return Optional.ofNullable(clazz.cast(this.throttlingRateLimit()));
            }
            case "cachingEnabled": {
                return Optional.ofNullable(clazz.cast(this.cachingEnabled()));
            }
            case "cacheTtlInSeconds": {
                return Optional.ofNullable(clazz.cast(this.cacheTtlInSeconds()));
            }
            case "cacheDataEncrypted": {
                return Optional.ofNullable(clazz.cast(this.cacheDataEncrypted()));
            }
            case "requireAuthorizationForCacheControl": {
                return Optional.ofNullable(clazz.cast(this.requireAuthorizationForCacheControl()));
            }
            case "unauthorizedCacheControlHeaderStrategy": {
                return Optional.ofNullable(clazz.cast(this.unauthorizedCacheControlHeaderStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MethodSettingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean metricsEnabled;
        private String loggingLevel;
        private Boolean dataTraceEnabled;
        private Integer throttlingBurstLimit;
        private Double throttlingRateLimit;
        private Boolean cachingEnabled;
        private Integer cacheTtlInSeconds;
        private Boolean cacheDataEncrypted;
        private Boolean requireAuthorizationForCacheControl;
        private String unauthorizedCacheControlHeaderStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(MethodSetting model) {
            this.metricsEnabled(model.metricsEnabled);
            this.loggingLevel(model.loggingLevel);
            this.dataTraceEnabled(model.dataTraceEnabled);
            this.throttlingBurstLimit(model.throttlingBurstLimit);
            this.throttlingRateLimit(model.throttlingRateLimit);
            this.cachingEnabled(model.cachingEnabled);
            this.cacheTtlInSeconds(model.cacheTtlInSeconds);
            this.cacheDataEncrypted(model.cacheDataEncrypted);
            this.requireAuthorizationForCacheControl(model.requireAuthorizationForCacheControl);
            this.unauthorizedCacheControlHeaderStrategy(model.unauthorizedCacheControlHeaderStrategy);
        }

        public final Boolean getMetricsEnabled() {
            return this.metricsEnabled;
        }

        @Override
        public final Builder metricsEnabled(Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        public final void setMetricsEnabled(Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
        }

        public final String getLoggingLevel() {
            return this.loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        public final Boolean getDataTraceEnabled() {
            return this.dataTraceEnabled;
        }

        @Override
        public final Builder dataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        public final void setDataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
        }

        public final Integer getThrottlingBurstLimit() {
            return this.throttlingBurstLimit;
        }

        @Override
        public final Builder throttlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        public final void setThrottlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
        }

        public final Double getThrottlingRateLimit() {
            return this.throttlingRateLimit;
        }

        @Override
        public final Builder throttlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        public final void setThrottlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
        }

        public final Boolean getCachingEnabled() {
            return this.cachingEnabled;
        }

        @Override
        public final Builder cachingEnabled(Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            return this;
        }

        public final void setCachingEnabled(Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
        }

        public final Integer getCacheTtlInSeconds() {
            return this.cacheTtlInSeconds;
        }

        @Override
        public final Builder cacheTtlInSeconds(Integer cacheTtlInSeconds) {
            this.cacheTtlInSeconds = cacheTtlInSeconds;
            return this;
        }

        public final void setCacheTtlInSeconds(Integer cacheTtlInSeconds) {
            this.cacheTtlInSeconds = cacheTtlInSeconds;
        }

        public final Boolean getCacheDataEncrypted() {
            return this.cacheDataEncrypted;
        }

        @Override
        public final Builder cacheDataEncrypted(Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
            return this;
        }

        public final void setCacheDataEncrypted(Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
        }

        public final Boolean getRequireAuthorizationForCacheControl() {
            return this.requireAuthorizationForCacheControl;
        }

        @Override
        public final Builder requireAuthorizationForCacheControl(Boolean requireAuthorizationForCacheControl) {
            this.requireAuthorizationForCacheControl = requireAuthorizationForCacheControl;
            return this;
        }

        public final void setRequireAuthorizationForCacheControl(Boolean requireAuthorizationForCacheControl) {
            this.requireAuthorizationForCacheControl = requireAuthorizationForCacheControl;
        }

        public final String getUnauthorizedCacheControlHeaderStrategy() {
            return this.unauthorizedCacheControlHeaderStrategy;
        }

        @Override
        public final Builder unauthorizedCacheControlHeaderStrategy(String unauthorizedCacheControlHeaderStrategy) {
            this.unauthorizedCacheControlHeaderStrategy = unauthorizedCacheControlHeaderStrategy;
            return this;
        }

        @Override
        public final Builder unauthorizedCacheControlHeaderStrategy(UnauthorizedCacheControlHeaderStrategy unauthorizedCacheControlHeaderStrategy) {
            this.unauthorizedCacheControlHeaderStrategy(unauthorizedCacheControlHeaderStrategy.toString());
            return this;
        }

        public final void setUnauthorizedCacheControlHeaderStrategy(String unauthorizedCacheControlHeaderStrategy) {
            this.unauthorizedCacheControlHeaderStrategy = unauthorizedCacheControlHeaderStrategy;
        }

        public MethodSetting build() {
            return new MethodSetting(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MethodSetting> {
        public Builder metricsEnabled(Boolean var1);

        public Builder loggingLevel(String var1);

        public Builder dataTraceEnabled(Boolean var1);

        public Builder throttlingBurstLimit(Integer var1);

        public Builder throttlingRateLimit(Double var1);

        public Builder cachingEnabled(Boolean var1);

        public Builder cacheTtlInSeconds(Integer var1);

        public Builder cacheDataEncrypted(Boolean var1);

        public Builder requireAuthorizationForCacheControl(Boolean var1);

        public Builder unauthorizedCacheControlHeaderStrategy(String var1);

        public Builder unauthorizedCacheControlHeaderStrategy(UnauthorizedCacheControlHeaderStrategy var1);
    }
}

