/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIntegrationResponseRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, GetIntegrationResponseRequest> {
    private final String restApiId;
    private final String resourceId;
    private final String httpMethod;
    private final String statusCode;

    private GetIntegrationResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.statusCode = builder.statusCode;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String statusCode() {
        return this.statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntegrationResponseRequest)) {
            return false;
        }
        GetIntegrationResponseRequest other = (GetIntegrationResponseRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.statusCode(), other.statusCode());
    }

    public String toString() {
        return ToString.builder((String)"GetIntegrationResponseRequest").add("RestApiId", (Object)this.restApiId()).add("ResourceId", (Object)this.resourceId()).add("HttpMethod", (Object)this.httpMethod()).add("StatusCode", (Object)this.statusCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String resourceId;
        private String httpMethod;
        private String statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntegrationResponseRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.resourceId(model.resourceId);
            this.httpMethod(model.httpMethod);
            this.statusCode(model.statusCode);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIntegrationResponseRequest build() {
            return new GetIntegrationResponseRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, GetIntegrationResponseRequest> {
        public Builder restApiId(String var1);

        public Builder resourceId(String var1);

        public Builder httpMethod(String var1);

        public Builder statusCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

