/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDocumentationPartRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, GetDocumentationPartRequest> {
    private final String restApiId;
    private final String documentationPartId;

    private GetDocumentationPartRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.documentationPartId = builder.documentationPartId;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String documentationPartId() {
        return this.documentationPartId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationPartId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentationPartRequest)) {
            return false;
        }
        GetDocumentationPartRequest other = (GetDocumentationPartRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.documentationPartId(), other.documentationPartId());
    }

    public String toString() {
        return ToString.builder((String)"GetDocumentationPartRequest").add("RestApiId", (Object)this.restApiId()).add("DocumentationPartId", (Object)this.documentationPartId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "documentationPartId": {
                return Optional.ofNullable(clazz.cast(this.documentationPartId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String documentationPartId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentationPartRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.documentationPartId(model.documentationPartId);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getDocumentationPartId() {
            return this.documentationPartId;
        }

        @Override
        public final Builder documentationPartId(String documentationPartId) {
            this.documentationPartId = documentationPartId;
            return this;
        }

        public final void setDocumentationPartId(String documentationPartId) {
            this.documentationPartId = documentationPartId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentationPartRequest build() {
            return new GetDocumentationPartRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, GetDocumentationPartRequest> {
        public Builder restApiId(String var1);

        public Builder documentationPartId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

