/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.DocumentationPartLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDocumentationPartRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateDocumentationPartRequest> {
    private final String restApiId;
    private final DocumentationPartLocation location;
    private final String properties;

    private CreateDocumentationPartRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.location = builder.location;
        this.properties = builder.properties;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public DocumentationPartLocation location() {
        return this.location;
    }

    public String properties() {
        return this.properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentationPartRequest)) {
            return false;
        }
        CreateDocumentationPartRequest other = (CreateDocumentationPartRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.properties(), other.properties());
    }

    public String toString() {
        return ToString.builder((String)"CreateDocumentationPartRequest").add("RestApiId", (Object)this.restApiId()).add("Location", (Object)this.location()).add("Properties", (Object)this.properties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private DocumentationPartLocation location;
        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentationPartRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.location(model.location);
            this.properties(model.properties);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final DocumentationPartLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(DocumentationPartLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(DocumentationPartLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getProperties() {
            return this.properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDocumentationPartRequest build() {
            return new CreateDocumentationPartRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, CreateDocumentationPartRequest> {
        public Builder restApiId(String var1);

        public Builder location(DocumentationPartLocation var1);

        default public Builder location(Consumer<DocumentationPartLocation.Builder> location) {
            return this.location((DocumentationPartLocation)((DocumentationPartLocation.Builder)DocumentationPartLocation.builder().applyMutation(location)).build());
        }

        public Builder properties(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

