/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.ssl.SSLInitializationException;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.apache5.ProxyConfiguration;
import software.amazon.awssdk.http.apache5.internal.Apache5HttpRequestConfig;
import software.amazon.awssdk.http.apache5.internal.DefaultConfiguration;
import software.amazon.awssdk.http.apache5.internal.SdkProxyRoutePlanner;
import software.amazon.awssdk.http.apache5.internal.conn.ClientConnectionManagerFactory;
import software.amazon.awssdk.http.apache5.internal.conn.ClientConnectionRequestFactory;
import software.amazon.awssdk.http.apache5.internal.conn.IdleConnectionReaper;
import software.amazon.awssdk.http.apache5.internal.conn.SdkConnectionKeepAliveStrategy;
import software.amazon.awssdk.http.apache5.internal.conn.SdkTlsSocketFactory;
import software.amazon.awssdk.http.apache5.internal.impl.Apache5HttpRequestFactory;
import software.amazon.awssdk.http.apache5.internal.impl.Apache5SdkHttpClient;
import software.amazon.awssdk.http.apache5.internal.impl.ConnectionManagerAwareHttpClient;
import software.amazon.awssdk.http.apache5.internal.utils.Apache5Utils;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class Apache5HttpClient
implements SdkHttpClient {
    private static final String CLIENT_NAME = "Apache5";
    private static final Logger log = Logger.loggerFor(Apache5HttpClient.class);
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = new DefaultHostnameVerifier();
    private final Apache5HttpRequestFactory apacheHttpRequestFactory = new Apache5HttpRequestFactory();
    private final ConnectionManagerAwareHttpClient httpClient;
    private final Apache5HttpRequestConfig requestConfig;
    private final AttributeMap resolvedOptions;

    @SdkTestInternalApi
    Apache5HttpClient(ConnectionManagerAwareHttpClient httpClient, Apache5HttpRequestConfig requestConfig, AttributeMap resolvedOptions) {
        this.httpClient = httpClient;
        this.requestConfig = requestConfig;
        this.resolvedOptions = resolvedOptions;
    }

    private Apache5HttpClient(DefaultBuilder builder, AttributeMap resolvedOptions) {
        this.httpClient = this.createClient(builder, resolvedOptions);
        this.requestConfig = this.createRequestConfig(builder, resolvedOptions);
        this.resolvedOptions = resolvedOptions;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static SdkHttpClient create() {
        return new DefaultBuilder().build();
    }

    private ConnectionManagerAwareHttpClient createClient(DefaultBuilder configuration, AttributeMap standardOptions) {
        ApacheConnectionManagerFactory cmFactory = new ApacheConnectionManagerFactory();
        HttpClientBuilder builder = HttpClients.custom();
        PoolingHttpClientConnectionManager cm = cmFactory.create(configuration, standardOptions);
        Registry authSchemeRegistry = configuration.authSchemeRegistry;
        if (authSchemeRegistry != null) {
            builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        }
        builder.setRequestExecutor(new HttpRequestExecutor()).disableContentCompression().setKeepAliveStrategy(this.buildKeepAliveStrategy(standardOptions)).setUserAgent("").setConnectionManager(ClientConnectionManagerFactory.wrap((HttpClientConnectionManager)cm)).disableRedirectHandling().disableAutomaticRetries();
        this.addProxyConfig(builder, configuration);
        if (this.useIdleConnectionReaper(standardOptions)) {
            IdleConnectionReaper.getInstance().registerConnectionManager(cm, ((Duration)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)).toMillis());
        }
        return new Apache5SdkHttpClient((HttpClient)builder.build(), (HttpClientConnectionManager)cm);
    }

    private void addProxyConfig(HttpClientBuilder builder, DefaultBuilder configuration) {
        ProxyConfiguration proxyConfiguration = configuration.proxyConfiguration;
        Validate.isTrue((configuration.httpRoutePlanner == null || !this.isProxyEnabled(proxyConfiguration) ? 1 : 0) != 0, (String)"The httpRoutePlanner and proxyConfiguration can't both be configured.", (Object[])new Object[0]);
        Validate.isTrue((configuration.credentialsProvider == null || !this.isAuthenticatedProxy(proxyConfiguration) ? 1 : 0) != 0, (String)"The credentialsProvider and proxyConfiguration username/password can't both be configured.", (Object[])new Object[0]);
        Object routePlanner = configuration.httpRoutePlanner;
        if (this.isProxyEnabled(proxyConfiguration)) {
            log.debug(() -> "Configuring Proxy. Proxy Host: " + proxyConfiguration.host());
            routePlanner = new SdkProxyRoutePlanner(proxyConfiguration.host(), proxyConfiguration.port(), proxyConfiguration.scheme(), proxyConfiguration.nonProxyHosts());
        }
        CredentialsProvider credentialsProvider = configuration.credentialsProvider;
        if (this.isAuthenticatedProxy(proxyConfiguration)) {
            credentialsProvider = Apache5Utils.newProxyCredentialsProvider(proxyConfiguration);
        }
        if (routePlanner != null) {
            if (configuration.localAddress != null) {
                log.debug(() -> "localAddress configuration was ignored since Route planner was explicitly provided");
            }
            builder.setRoutePlanner(routePlanner);
        } else if (configuration.localAddress != null) {
            builder.setRoutePlanner((HttpRoutePlanner)new LocalAddressRoutePlanner(configuration.localAddress));
        }
        if (credentialsProvider != null) {
            builder.setDefaultCredentialsProvider(credentialsProvider);
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(AttributeMap standardOptions) {
        long maxIdle = ((Duration)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)).toMillis();
        return maxIdle > 0L ? new SdkConnectionKeepAliveStrategy(maxIdle) : null;
    }

    private boolean useIdleConnectionReaper(AttributeMap standardOptions) {
        return Boolean.TRUE.equals(standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS));
    }

    private boolean isAuthenticatedProxy(ProxyConfiguration proxyConfiguration) {
        return proxyConfiguration.username() != null && proxyConfiguration.password() != null;
    }

    private boolean isProxyEnabled(ProxyConfiguration proxyConfiguration) {
        return proxyConfiguration.host() != null && proxyConfiguration.port() > 0;
    }

    public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
        final MetricCollector metricCollector = request.metricCollector().orElseGet(NoOpMetricCollector::create);
        metricCollector.reportMetric(HttpMetric.HTTP_CLIENT_NAME, (Object)this.clientName());
        final HttpUriRequestBase apacheRequest = this.toApacheRequest(request);
        return new ExecutableHttpRequest(){

            public HttpExecuteResponse call() throws IOException {
                HttpExecuteResponse executeResponse = Apache5HttpClient.this.execute(apacheRequest, metricCollector);
                Apache5HttpClient.this.collectPoolMetric(metricCollector);
                return executeResponse;
            }

            public void abort() {
                apacheRequest.abort();
            }
        };
    }

    public void close() {
        HttpClientConnectionManager cm = this.httpClient.getHttpClientConnectionManager();
        IdleConnectionReaper.getInstance().deregisterConnectionManager(cm);
        cm.close(CloseMode.IMMEDIATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpExecuteResponse execute(HttpUriRequestBase apacheRequest, MetricCollector metricCollector) throws IOException {
        HttpClientContext localRequestContext = Apache5Utils.newClientContext(this.requestConfig.proxyConfiguration());
        ClientConnectionRequestFactory.THREAD_LOCAL_REQUEST_METRIC_COLLECTOR.set(metricCollector);
        try {
            HttpHost target = Apache5HttpClient.determineTarget((ClassicHttpRequest)apacheRequest);
            ClassicHttpResponse httpResponse = this.httpClient.executeOpen(target, (ClassicHttpRequest)apacheRequest, (HttpContext)localRequestContext);
            HttpExecuteResponse httpExecuteResponse = this.createResponse((HttpResponse)httpResponse, apacheRequest);
            return httpExecuteResponse;
        }
        finally {
            ClientConnectionRequestFactory.THREAD_LOCAL_REQUEST_METRIC_COLLECTOR.remove();
        }
    }

    private static HttpHost determineTarget(ClassicHttpRequest request) throws IOException {
        try {
            return RoutingSupport.determineHost((HttpRequest)request);
        }
        catch (HttpException ex) {
            throw new ClientProtocolException((Throwable)ex);
        }
    }

    private HttpUriRequestBase toApacheRequest(HttpExecuteRequest request) {
        return this.apacheHttpRequestFactory.create(request, this.requestConfig);
    }

    private HttpExecuteResponse createResponse(HttpResponse apacheHttpResponse, HttpUriRequestBase apacheRequest) throws IOException {
        SdkHttpFullResponse.Builder responseBuilder = SdkHttpResponse.builder().statusCode(apacheHttpResponse.getCode()).statusText(apacheHttpResponse.getReasonPhrase());
        Iterator headerIterator = apacheHttpResponse.headerIterator();
        while (headerIterator.hasNext()) {
            Header header = (Header)headerIterator.next();
            responseBuilder.appendHeader(header.getName(), header.getValue());
        }
        AbortableInputStream responseBody = this.getResponseBody(apacheHttpResponse, apacheRequest);
        return HttpExecuteResponse.builder().response((SdkHttpResponse)responseBuilder.build()).responseBody(responseBody).build();
    }

    private AbortableInputStream getResponseBody(HttpResponse apacheHttpResponse, HttpUriRequestBase apacheRequest) throws IOException {
        AbortableInputStream responseBody = null;
        if (apacheHttpResponse instanceof ClassicHttpResponse) {
            ClassicHttpResponse classicResponse = (ClassicHttpResponse)apacheHttpResponse;
            HttpEntity entity = classicResponse.getEntity();
            if (entity != null) {
                if (entity.getContentLength() == 0L) {
                    classicResponse.close();
                    responseBody = AbortableInputStream.create((InputStream)new ByteArrayInputStream(new byte[0]));
                } else {
                    responseBody = this.toAbortableInputStream(classicResponse, apacheRequest);
                }
            } else {
                classicResponse.close();
            }
        }
        return responseBody;
    }

    private AbortableInputStream toAbortableInputStream(ClassicHttpResponse apacheResponse, HttpUriRequestBase apacheRequest) throws IOException {
        return AbortableInputStream.create((InputStream)apacheResponse.getEntity().getContent(), () -> ((HttpUriRequestBase)apacheRequest).abort());
    }

    private Apache5HttpRequestConfig createRequestConfig(DefaultBuilder builder, AttributeMap resolvedOptions) {
        return Apache5HttpRequestConfig.builder().socketTimeout((Duration)resolvedOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).connectionAcquireTimeout((Duration)resolvedOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)).proxyConfiguration(builder.proxyConfiguration).expectContinueEnabled(Optional.ofNullable(builder.expectContinueEnabled).orElse(DefaultConfiguration.EXPECT_CONTINUE_ENABLED)).build();
    }

    private void collectPoolMetric(MetricCollector metricCollector) {
        HttpClientConnectionManager cm = this.httpClient.getHttpClientConnectionManager();
        if (cm instanceof PoolingHttpClientConnectionManager && !(metricCollector instanceof NoOpMetricCollector)) {
            PoolingHttpClientConnectionManager poolingCm = (PoolingHttpClientConnectionManager)cm;
            PoolStats totalStats = poolingCm.getTotalStats();
            metricCollector.reportMetric(HttpMetric.MAX_CONCURRENCY, (Object)totalStats.getMax());
            metricCollector.reportMetric(HttpMetric.AVAILABLE_CONCURRENCY, (Object)totalStats.getAvailable());
            metricCollector.reportMetric(HttpMetric.LEASED_CONCURRENCY, (Object)totalStats.getLeased());
            metricCollector.reportMetric(HttpMetric.PENDING_CONCURRENCY_ACQUIRES, (Object)totalStats.getPending());
        }
    }

    public String clientName() {
        return CLIENT_NAME;
    }

    private static class LocalAddressRoutePlanner
    extends DefaultRoutePlanner {
        private final InetAddress localAddress;

        LocalAddressRoutePlanner(InetAddress localAddress) {
            super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
            this.localAddress = localAddress;
        }

        protected InetAddress determineLocalAddress(HttpHost firstHop, HttpContext context) throws HttpException {
            return this.localAddress;
        }
    }

    private static class ApacheConnectionManagerFactory {
        private ApacheConnectionManagerFactory() {
        }

        public PoolingHttpClientConnectionManager create(DefaultBuilder configuration, AttributeMap standardOptions) {
            TlsSocketStrategy tlsStrategy = this.getPreferredTlsStrategy(configuration, standardOptions);
            PoolingHttpClientConnectionManagerBuilder builder = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(tlsStrategy).setSchemePortResolver((SchemePortResolver)DefaultSchemePortResolver.INSTANCE).setDnsResolver(configuration.dnsResolver);
            builder.setMaxConnPerRoute(((Integer)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS)).intValue());
            builder.setMaxConnTotal(((Integer)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS)).intValue());
            builder.setDefaultSocketConfig(this.buildSocketConfig(standardOptions));
            builder.setDefaultConnectionConfig(ApacheConnectionManagerFactory.getConnectionConfig(standardOptions));
            return builder.build();
        }

        private static ConnectionConfig getConnectionConfig(AttributeMap standardOptions) {
            ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)((Duration)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)).toMillis())).setSocketTimeout(Timeout.ofMilliseconds((long)((Duration)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).toMillis()));
            Duration connectionTtl = (Duration)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE);
            if (!connectionTtl.isNegative() && !connectionTtl.isZero()) {
                connectionConfigBuilder.setTimeToLive(TimeValue.ofMilliseconds((long)connectionTtl.toMillis()));
            }
            return connectionConfigBuilder.build();
        }

        private TlsSocketStrategy getPreferredTlsStrategy(DefaultBuilder configuration, AttributeMap standardOptions) {
            if (configuration.tlsStrategy != null) {
                return configuration.tlsStrategy;
            }
            return new SdkTlsSocketFactory(this.getSslContext(standardOptions), this.getHostNameVerifier(standardOptions));
        }

        private HostnameVerifier getHostNameVerifier(AttributeMap standardOptions) {
            return (Boolean)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES) != false ? NoopHostnameVerifier.INSTANCE : DEFAULT_HOSTNAME_VERIFIER;
        }

        private SSLContext getSslContext(AttributeMap standardOptions) {
            Validate.isTrue((standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER) == null || (Boolean)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES) == false ? 1 : 0) != 0, (String)"A TlsTrustManagerProvider can't be provided if TrustAllCertificates is also set", (Object[])new Object[0]);
            TrustManager[] trustManagers = null;
            if (standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER) != null) {
                trustManagers = ((TlsTrustManagersProvider)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER)).trustManagers();
            }
            if (((Boolean)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES)).booleanValue()) {
                log.warn(() -> "SSL Certificate verification is disabled. This is not a safe setting and should only be used for testing.");
                trustManagers = ApacheConnectionManagerFactory.trustAllTrustManager();
            }
            TlsKeyManagersProvider provider = (TlsKeyManagersProvider)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TLS_KEY_MANAGERS_PROVIDER);
            KeyManager[] keyManagers = provider.keyManagers();
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(keyManagers, trustManagers, null);
                return sslcontext;
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                throw new SSLInitializationException(ex.getMessage(), (Throwable)ex);
            }
        }

        private static TrustManager[] trustAllTrustManager() {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    log.debug(() -> "Accepting a client certificate: " + x509Certificates[0].getSubjectDN());
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    log.debug(() -> "Accepting a client certificate: " + x509Certificates[0].getSubjectDN());
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }

        private SocketConfig buildSocketConfig(AttributeMap standardOptions) {
            return SocketConfig.custom().setSoKeepAlive(((Boolean)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.TCP_KEEPALIVE)).booleanValue()).setSoTimeout(NumericUtils.saturatedCast((long)((Duration)standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)).toMillis()), TimeUnit.MILLISECONDS).setTcpNoDelay(true).build();
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();
        private Registry<AuthSchemeFactory> authSchemeRegistry;
        private ProxyConfiguration proxyConfiguration = (ProxyConfiguration)ProxyConfiguration.builder().build();
        private InetAddress localAddress;
        private Boolean expectContinueEnabled;
        private HttpRoutePlanner httpRoutePlanner;
        private CredentialsProvider credentialsProvider;
        private DnsResolver dnsResolver;
        private TlsSocketStrategy tlsStrategy;

        private DefaultBuilder() {
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder connectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            Validate.isPositive((Duration)connectionAcquisitionTimeout, (String)"connectionAcquisitionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT, (Object)connectionAcquisitionTimeout);
            return this;
        }

        public void setConnectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            this.connectionAcquisitionTimeout(connectionAcquisitionTimeout);
        }

        @Override
        public Builder maxConnections(Integer maxConnections) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConnections);
            return this;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections(maxConnections);
        }

        @Override
        public Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration(proxyConfiguration);
        }

        @Override
        public Builder localAddress(InetAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public void setLocalAddress(InetAddress localAddress) {
            this.localAddress(localAddress);
        }

        @Override
        public Builder expectContinueEnabled(Boolean expectContinueEnabled) {
            this.expectContinueEnabled = expectContinueEnabled;
            return this;
        }

        public void setExpectContinueEnabled(Boolean useExpectContinue) {
            this.expectContinueEnabled = useExpectContinue;
        }

        @Override
        public Builder connectionTimeToLive(Duration connectionTimeToLive) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE, (Object)connectionTimeToLive);
            return this;
        }

        public void setConnectionTimeToLive(Duration connectionTimeToLive) {
            this.connectionTimeToLive(connectionTimeToLive);
        }

        @Override
        public Builder connectionMaxIdleTime(Duration maxIdleConnectionTimeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)maxIdleConnectionTimeout);
            return this;
        }

        public void setConnectionMaxIdleTime(Duration connectionMaxIdleTime) {
            this.connectionMaxIdleTime(connectionMaxIdleTime);
        }

        @Override
        public Builder useIdleConnectionReaper(Boolean useIdleConnectionReaper) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS, (Object)useIdleConnectionReaper);
            return this;
        }

        public void setUseIdleConnectionReaper(Boolean useIdleConnectionReaper) {
            this.useIdleConnectionReaper(useIdleConnectionReaper);
        }

        @Override
        public Builder dnsResolver(DnsResolver dnsResolver) {
            this.dnsResolver = dnsResolver;
            return this;
        }

        public void setDnsResolver(DnsResolver dnsResolver) {
            this.dnsResolver(dnsResolver);
        }

        @Override
        public Builder tlsSocketStrategy(TlsSocketStrategy tlsSocketStrategy) {
            this.tlsStrategy = tlsSocketStrategy;
            return this;
        }

        @Override
        public Builder httpRoutePlanner(HttpRoutePlanner httpRoutePlanner) {
            this.httpRoutePlanner = httpRoutePlanner;
            return this;
        }

        public void setHttpRoutePlanner(HttpRoutePlanner httpRoutePlanner) {
            this.httpRoutePlanner(httpRoutePlanner);
        }

        @Override
        public Builder credentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider(credentialsProvider);
        }

        @Override
        public Builder tcpKeepAlive(Boolean keepConnectionAlive) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.TCP_KEEPALIVE, (Object)keepConnectionAlive);
            return this;
        }

        public void setTcpKeepAlive(Boolean keepConnectionAlive) {
            this.tcpKeepAlive(keepConnectionAlive);
        }

        @Override
        public Builder tlsKeyManagersProvider(TlsKeyManagersProvider tlsKeyManagersProvider) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.TLS_KEY_MANAGERS_PROVIDER, (Object)tlsKeyManagersProvider);
            return this;
        }

        public void setTlsKeyManagersProvider(TlsKeyManagersProvider tlsKeyManagersProvider) {
            this.tlsKeyManagersProvider(tlsKeyManagersProvider);
        }

        @Override
        public Builder tlsTrustManagersProvider(TlsTrustManagersProvider tlsTrustManagersProvider) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER, (Object)tlsTrustManagersProvider);
            return this;
        }

        public void setTlsTrustManagersProvider(TlsTrustManagersProvider tlsTrustManagersProvider) {
            this.tlsTrustManagersProvider(tlsTrustManagersProvider);
        }

        @Override
        public Builder authSchemeRegistry(Registry<AuthSchemeFactory> authSchemeRegistry) {
            this.authSchemeRegistry = authSchemeRegistry;
            return this;
        }

        public void setAuthSchemeProviderRegistry(Registry<AuthSchemeFactory> authSchemeRegistry) {
            this.authSchemeRegistry(authSchemeRegistry);
        }

        public SdkHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            AttributeMap resolvedOptions = this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS);
            return new Apache5HttpClient(this, resolvedOptions);
        }
    }

    public static interface Builder
    extends SdkHttpClient.Builder<Builder> {
        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder connectionAcquisitionTimeout(Duration var1);

        public Builder maxConnections(Integer var1);

        public Builder proxyConfiguration(ProxyConfiguration var1);

        public Builder localAddress(InetAddress var1);

        public Builder expectContinueEnabled(Boolean var1);

        public Builder connectionTimeToLive(Duration var1);

        public Builder connectionMaxIdleTime(Duration var1);

        public Builder useIdleConnectionReaper(Boolean var1);

        public Builder dnsResolver(DnsResolver var1);

        public Builder tlsSocketStrategy(TlsSocketStrategy var1);

        public Builder httpRoutePlanner(HttpRoutePlanner var1);

        public Builder credentialsProvider(CredentialsProvider var1);

        public Builder tcpKeepAlive(Boolean var1);

        public Builder tlsKeyManagersProvider(TlsKeyManagersProvider var1);

        public Builder tlsTrustManagersProvider(TlsTrustManagersProvider var1);

        public Builder authSchemeRegistry(Registry<AuthSchemeFactory> var1);
    }
}

