/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.apache5.ProxyConfiguration;

@SdkInternalApi
public final class Apache5Utils {
    private Apache5Utils() {
    }

    public static HttpEntity newBufferedHttpEntity(HttpEntity entity) {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpClientContext newClientContext(ProxyConfiguration proxyConfiguration) {
        HttpClientContext clientContext = new HttpClientContext();
        Apache5Utils.addPreemptiveAuthenticationProxy(clientContext, proxyConfiguration);
        RequestConfig.Builder builder = RequestConfig.custom();
        clientContext.setRequestConfig(builder.build());
        return clientContext;
    }

    public static CredentialsProvider newProxyCredentialsProvider(ProxyConfiguration proxyConfiguration) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(Apache5Utils.newAuthScope(proxyConfiguration), Apache5Utils.proxyCredentials(proxyConfiguration));
        return provider;
    }

    private static NTCredentials ntCredentials(ProxyConfiguration proxyConfiguration) {
        return new NTCredentials(proxyConfiguration.username(), proxyConfiguration.password().toCharArray(), proxyConfiguration.ntlmWorkstation(), proxyConfiguration.ntlmDomain());
    }

    private static Credentials proxyCredentials(ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration.ntlmWorkstation() != null || proxyConfiguration.ntlmDomain() != null) {
            return Apache5Utils.ntCredentials(proxyConfiguration);
        }
        return Apache5Utils.usernamePasswordCredentials(proxyConfiguration);
    }

    public static UsernamePasswordCredentials usernamePasswordCredentials(ProxyConfiguration proxyConfiguration) {
        return new UsernamePasswordCredentials(proxyConfiguration.username(), proxyConfiguration.password().toCharArray());
    }

    private static AuthScope newAuthScope(ProxyConfiguration proxyConfiguration) {
        return new AuthScope(proxyConfiguration.host(), proxyConfiguration.port());
    }

    private static void addPreemptiveAuthenticationProxy(HttpClientContext clientContext, ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration.preemptiveBasicAuthenticationEnabled().booleanValue()) {
            HttpHost targetHost = new HttpHost(proxyConfiguration.host(), proxyConfiguration.port());
            CredentialsProvider credsProvider = Apache5Utils.newProxyCredentialsProvider(proxyConfiguration);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            basicAuth.initPreemptive(credsProvider.getCredentials(Apache5Utils.newAuthScope(proxyConfiguration), (HttpContext)clientContext));
            authCache.put(targetHost, (AuthScheme)basicAuth);
            clientContext.setCredentialsProvider(credsProvider);
            clientContext.setAuthCache((AuthCache)authCache);
        }
    }
}

