/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache5.internal.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.HttpEntity;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.apache5.internal.Apache5HttpRequestConfig;
import software.amazon.awssdk.http.apache5.internal.RepeatableInputStreamRequestEntity;
import software.amazon.awssdk.http.apache5.internal.utils.Apache5Utils;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public class Apache5HttpRequestFactory {
    private static final List<String> IGNORE_HEADERS = Arrays.asList("Content-Length", "Host", "Transfer-Encoding");

    public HttpUriRequestBase create(HttpExecuteRequest request, Apache5HttpRequestConfig requestConfig) {
        HttpUriRequestBase base = this.createApacheRequest(request, this.sanitizeUri(request.httpRequest()));
        this.addHeadersToRequest(base, request.httpRequest());
        this.addRequestConfig(base, request.httpRequest(), requestConfig);
        return base;
    }

    private URI sanitizeUri(SdkHttpRequest request) {
        String path = request.encodedPath();
        if (path.contains("//")) {
            int port = request.port();
            String protocol = request.protocol();
            String newPath = StringUtils.replace((String)path, (String)"//", (String)"/%2F");
            String encodedQueryString = request.encodedQueryParameters().map(value -> "?" + value).orElse("");
            String portString = SdkHttpUtils.isUsingStandardPort((String)protocol, (Integer)port) ? "" : ":" + port;
            return URI.create(protocol + "://" + request.host() + portString + newPath + encodedQueryString);
        }
        return request.getUri();
    }

    private void addRequestConfig(HttpUriRequestBase base, SdkHttpRequest request, Apache5HttpRequestConfig requestConfig) {
        int connectTimeout = NumericUtils.saturatedCast((long)requestConfig.connectionTimeout().toMillis());
        int connectAcquireTimeout = NumericUtils.saturatedCast((long)requestConfig.connectionAcquireTimeout().toMillis());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout((long)connectAcquireTimeout, TimeUnit.MILLISECONDS).setConnectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout((long)NumericUtils.saturatedCast((long)requestConfig.socketTimeout().toMillis()), TimeUnit.MILLISECONDS);
        if (SdkHttpMethod.PUT == request.method() && requestConfig.expectContinueEnabled()) {
            requestConfigBuilder.setExpectContinueEnabled(true);
        }
        base.setConfig(requestConfigBuilder.build());
    }

    private HttpUriRequestBase createApacheRequest(HttpExecuteRequest request, URI uri) {
        switch (request.httpRequest().method()) {
            case HEAD: {
                return new HttpHead(uri);
            }
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case PATCH: {
                return this.wrapEntity(request, (HttpUriRequestBase)new HttpPatch(uri));
            }
            case POST: {
                return this.wrapEntity(request, (HttpUriRequestBase)new HttpPost(uri));
            }
            case PUT: {
                return this.wrapEntity(request, (HttpUriRequestBase)new HttpPut(uri));
            }
        }
        throw new RuntimeException("Unknown HTTP method name: " + request.httpRequest().method());
    }

    private HttpUriRequestBase wrapEntity(HttpExecuteRequest request, HttpUriRequestBase entityEnclosingRequest) {
        if (request.contentStreamProvider().isPresent()) {
            RepeatableInputStreamRequestEntity entity = new RepeatableInputStreamRequestEntity(request);
            if (!request.httpRequest().firstMatchingHeader("Content-Length").isPresent() && !entity.isChunked()) {
                entity = Apache5Utils.newBufferedHttpEntity((HttpEntity)entity);
            }
            entityEnclosingRequest.setEntity((HttpEntity)entity);
        }
        return entityEnclosingRequest;
    }

    private void addHeadersToRequest(HttpUriRequestBase httpRequest, SdkHttpRequest request) {
        httpRequest.addHeader("Host", (Object)this.getHostHeaderValue(request));
        request.forEachHeader((name, value) -> {
            if (IGNORE_HEADERS.stream().noneMatch(name::equalsIgnoreCase)) {
                for (String headerValue : value) {
                    httpRequest.addHeader(name, (Object)headerValue);
                }
            }
        });
    }

    private String getHostHeaderValue(SdkHttpRequest request) {
        Optional existingHostHeader = request.firstMatchingHeader("Host");
        if (existingHostHeader.isPresent()) {
            return (String)existingHostHeader.get();
        }
        return !SdkHttpUtils.isUsingStandardPort((String)request.protocol(), (Integer)request.port()) ? request.host() + ":" + request.port() : request.host();
    }
}

