/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentOverridesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ComponentVariantValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentVariant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentVariant> {
    private static final SdkField<Map<String, String>> VARIANT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("variantValues").getter(ComponentVariant.getter(ComponentVariant::variantValues)).setter(ComponentVariant.setter(Builder::variantValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variantValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("overrides").getter(ComponentVariant.getter(ComponentVariant::overrides)).setter(ComponentVariant.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_VALUES_FIELD, OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("variantValues", VARIANT_VALUES_FIELD);
            this.put("overrides", OVERRIDES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, String> variantValues;
    private final Map<String, Map<String, String>> overrides;

    private ComponentVariant(BuilderImpl builder) {
        this.variantValues = builder.variantValues;
        this.overrides = builder.overrides;
    }

    public final boolean hasVariantValues() {
        return this.variantValues != null && !(this.variantValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variantValues() {
        return this.variantValues;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariantValues() ? this.variantValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVariant)) {
            return false;
        }
        ComponentVariant other = (ComponentVariant)obj;
        return this.hasVariantValues() == other.hasVariantValues() && Objects.equals(this.variantValues(), other.variantValues()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentVariant").add("VariantValues", this.hasVariantValues() ? this.variantValues() : null).add("Overrides", this.hasOverrides() ? this.overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variantValues": {
                return Optional.ofNullable(clazz.cast(this.variantValues()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ComponentVariant, T> g) {
        return obj -> g.apply((ComponentVariant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> variantValues = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Map<String, String>> overrides = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentVariant model) {
            this.variantValues(model.variantValues);
            this.overrides(model.overrides);
        }

        public final Map<String, String> getVariantValues() {
            if (this.variantValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variantValues;
        }

        public final void setVariantValues(Map<String, String> variantValues) {
            this.variantValues = ComponentVariantValuesCopier.copy(variantValues);
        }

        @Override
        public final Builder variantValues(Map<String, String> variantValues) {
            this.variantValues = ComponentVariantValuesCopier.copy(variantValues);
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getOverrides() {
            if (this.overrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.overrides;
        }

        public final void setOverrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
        }

        @Override
        public final Builder overrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
            return this;
        }

        public ComponentVariant build() {
            return new ComponentVariant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentVariant> {
        public Builder variantValues(Map<String, String> var1);

        public Builder overrides(Map<String, ? extends Map<String, String>> var1);
    }
}

