/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderAsyncClient;
import software.amazon.awssdk.services.amplifyuibuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormSummary;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse;

public class ListFormsPublisher
implements SdkPublisher<ListFormsResponse> {
    private final AmplifyUiBuilderAsyncClient client;
    private final ListFormsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFormsPublisher(AmplifyUiBuilderAsyncClient client, ListFormsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFormsPublisher(AmplifyUiBuilderAsyncClient client, ListFormsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFormsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFormsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FormSummary> entities() {
        Function<ListFormsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFormsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFormsResponseFetcher
    implements AsyncPageFetcher<ListFormsResponse> {
        private ListFormsResponseFetcher() {
        }

        public boolean hasNextPage(ListFormsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFormsResponse> nextPage(ListFormsResponse previousPage) {
            if (previousPage == null) {
                return ListFormsPublisher.this.client.listForms(ListFormsPublisher.this.firstRequest);
            }
            return ListFormsPublisher.this.client.listForms((ListFormsRequest)((Object)ListFormsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

