/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderAsyncClient;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ThemeSummary;

public class ListThemesPublisher
implements SdkPublisher<ListThemesResponse> {
    private final AmplifyUiBuilderAsyncClient client;
    private final ListThemesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThemesPublisher(AmplifyUiBuilderAsyncClient client, ListThemesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThemesPublisher(AmplifyUiBuilderAsyncClient client, ListThemesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThemesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThemesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ThemeSummary> entities() {
        Function<ListThemesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThemesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThemesResponseFetcher
    implements AsyncPageFetcher<ListThemesResponse> {
        private ListThemesResponseFetcher() {
        }

        public boolean hasNextPage(ListThemesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThemesResponse> nextPage(ListThemesResponse previousPage) {
            if (previousPage == null) {
                return ListThemesPublisher.this.client.listThemes(ListThemesPublisher.this.firstRequest);
            }
            return ListThemesPublisher.this.client.listThemes((ListThemesRequest)((Object)ListThemesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

