/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.TagsCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues;
import software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateThemeData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateThemeData> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateThemeData.getter(CreateThemeData::name)).setter(CreateThemeData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<ThemeValues>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("overrides").getter(CreateThemeData.getter(CreateThemeData::overrides)).setter(CreateThemeData.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThemeValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateThemeData.getter(CreateThemeData::tags)).setter(CreateThemeData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ThemeValues>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(CreateThemeData.getter(CreateThemeData::values)).setter(CreateThemeData.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThemeValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OVERRIDES_FIELD, TAGS_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ThemeValues> overrides;
    private final Map<String, String> tags;
    private final List<ThemeValues> values;

    private CreateThemeData(BuilderImpl builder) {
        this.name = builder.name;
        this.overrides = builder.overrides;
        this.tags = builder.tags;
        this.values = builder.values;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructList);
    }

    public final List<ThemeValues> overrides() {
        return this.overrides;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<ThemeValues> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeData)) {
            return false;
        }
        CreateThemeData other = (CreateThemeData)obj;
        return Objects.equals(this.name(), other.name()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"CreateThemeData").add("Name", (Object)this.name()).add("Overrides", this.hasOverrides() ? this.overrides() : null).add("Tags", this.hasTags() ? this.tags() : null).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThemeData, T> g) {
        return obj -> g.apply((CreateThemeData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<ThemeValues> overrides = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<ThemeValues> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThemeData model) {
            this.name(model.name);
            this.overrides(model.overrides);
            this.tags(model.tags);
            this.values(model.values);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ThemeValues.Builder> getOverrides() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<ThemeValues.BuilderImpl> overrides) {
            this.overrides = ThemeValuesListCopier.copyFromBuilder(overrides);
        }

        @Override
        @Transient
        public final Builder overrides(Collection<ThemeValues> overrides) {
            this.overrides = ThemeValuesListCopier.copy(overrides);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder overrides(ThemeValues ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder overrides(Consumer<ThemeValues.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (ThemeValues)((ThemeValues.Builder)ThemeValues.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final List<ThemeValues.Builder> getValues() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<ThemeValues.BuilderImpl> values) {
            this.values = ThemeValuesListCopier.copyFromBuilder(values);
        }

        @Override
        @Transient
        public final Builder values(Collection<ThemeValues> values) {
            this.values = ThemeValuesListCopier.copy(values);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(ThemeValues ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(Consumer<ThemeValues.Builder> ... values) {
            this.values(Stream.of(values).map(c -> (ThemeValues)((ThemeValues.Builder)ThemeValues.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreateThemeData build() {
            return new CreateThemeData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateThemeData> {
        public Builder name(String var1);

        public Builder overrides(Collection<ThemeValues> var1);

        public Builder overrides(ThemeValues ... var1);

        public Builder overrides(Consumer<ThemeValues.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder values(Collection<ThemeValues> var1);

        public Builder values(ThemeValues ... var1);

        public Builder values(Consumer<ThemeValues.Builder> ... var1);
    }
}

