/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackendApiModelsResponse
extends AmplifyBackendResponse
implements ToCopyableBuilder<Builder, GetBackendApiModelsResponse> {
    private static final SdkField<String> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Models").getter(GetBackendApiModelsResponse.getter(GetBackendApiModelsResponse::models)).setter(GetBackendApiModelsResponse.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetBackendApiModelsResponse.getter(GetBackendApiModelsResponse::statusAsString)).setter(GetBackendApiModelsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> MODEL_INTROSPECTION_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelIntrospectionSchema").getter(GetBackendApiModelsResponse.getter(GetBackendApiModelsResponse::modelIntrospectionSchema)).setter(GetBackendApiModelsResponse.setter(Builder::modelIntrospectionSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelIntrospectionSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODELS_FIELD, STATUS_FIELD, MODEL_INTROSPECTION_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("models", MODELS_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("modelIntrospectionSchema", MODEL_INTROSPECTION_SCHEMA_FIELD);
        }
    });
    private final String models;
    private final String status;
    private final String modelIntrospectionSchema;

    private GetBackendApiModelsResponse(BuilderImpl builder) {
        super(builder);
        this.models = builder.models;
        this.status = builder.status;
        this.modelIntrospectionSchema = builder.modelIntrospectionSchema;
    }

    public final String models() {
        return this.models;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String modelIntrospectionSchema() {
        return this.modelIntrospectionSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.models());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelIntrospectionSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackendApiModelsResponse)) {
            return false;
        }
        GetBackendApiModelsResponse other = (GetBackendApiModelsResponse)((Object)obj);
        return Objects.equals(this.models(), other.models()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modelIntrospectionSchema(), other.modelIntrospectionSchema());
    }

    public final String toString() {
        return ToString.builder((String)"GetBackendApiModelsResponse").add("Models", (Object)this.models()).add("Status", (Object)this.statusAsString()).add("ModelIntrospectionSchema", (Object)this.modelIntrospectionSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ModelIntrospectionSchema": {
                return Optional.ofNullable(clazz.cast(this.modelIntrospectionSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetBackendApiModelsResponse, T> g) {
        return obj -> g.apply((GetBackendApiModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendResponse.BuilderImpl
    implements Builder {
        private String models;
        private String status;
        private String modelIntrospectionSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackendApiModelsResponse model) {
            super(model);
            this.models(model.models);
            this.status(model.status);
            this.modelIntrospectionSchema(model.modelIntrospectionSchema);
        }

        public final String getModels() {
            return this.models;
        }

        public final void setModels(String models) {
            this.models = models;
        }

        @Override
        public final Builder models(String models) {
            this.models = models;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelIntrospectionSchema() {
            return this.modelIntrospectionSchema;
        }

        public final void setModelIntrospectionSchema(String modelIntrospectionSchema) {
            this.modelIntrospectionSchema = modelIntrospectionSchema;
        }

        @Override
        public final Builder modelIntrospectionSchema(String modelIntrospectionSchema) {
            this.modelIntrospectionSchema = modelIntrospectionSchema;
            return this;
        }

        @Override
        public GetBackendApiModelsResponse build() {
            return new GetBackendApiModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyBackendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackendApiModelsResponse> {
        public Builder models(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder modelIntrospectionSchema(String var1);
    }
}

