/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SignInMethod {
    EMAIL("EMAIL"),
    EMAIL_AND_PHONE_NUMBER("EMAIL_AND_PHONE_NUMBER"),
    PHONE_NUMBER("PHONE_NUMBER"),
    USERNAME("USERNAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SignInMethod> VALUE_MAP;
    private final String value;

    private SignInMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SignInMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SignInMethod> knownValues() {
        EnumSet<SignInMethod> knownValues = EnumSet.allOf(SignInMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SignInMethod.class, SignInMethod::toString);
    }
}

