/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OAuthGrantType {
    CODE("CODE"),
    IMPLICIT("IMPLICIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OAuthGrantType> VALUE_MAP;
    private final String value;

    private OAuthGrantType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OAuthGrantType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OAuthGrantType> knownValues() {
        EnumSet<OAuthGrantType> knownValues = EnumSet.allOf(OAuthGrantType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OAuthGrantType.class, OAuthGrantType::toString);
    }
}

