/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ListOfOAuthScopesElementCopier {
    static List<String> copy(Collection<String> listOfOAuthScopesElementParam) {
        if (listOfOAuthScopesElementParam == null || listOfOAuthScopesElementParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<String> listOfOAuthScopesElementParamCopy = new ArrayList<>(listOfOAuthScopesElementParam);
        return Collections.unmodifiableList(listOfOAuthScopesElementParamCopy);
    }

    static List<String> copyEnumToString(Collection<OAuthScopesElement> listOfOAuthScopesElementParam) {
        if (listOfOAuthScopesElementParam == null || listOfOAuthScopesElementParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<String> listOfOAuthScopesElementParamCopy = listOfOAuthScopesElementParam.stream().map(Object::toString)
                .collect(toList());
        return Collections.unmodifiableList(listOfOAuthScopesElementParamCopy);
    }

    static List<OAuthScopesElement> copyStringToEnum(Collection<String> listOfOAuthScopesElementParam) {
        if (listOfOAuthScopesElementParam == null || listOfOAuthScopesElementParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<OAuthScopesElement> listOfOAuthScopesElementParamCopy = listOfOAuthScopesElementParam.stream()
                .map(OAuthScopesElement::fromValue).collect(toList());
        return Collections.unmodifiableList(listOfOAuthScopesElementParamCopy);
    }
}
