/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTokenResponse extends AmplifyBackendResponse implements
        ToCopyableBuilder<CreateTokenResponse.Builder, CreateTokenResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(CreateTokenResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> CHALLENGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChallengeCode").getter(getter(CreateTokenResponse::challengeCode))
            .setter(setter(Builder::challengeCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("challengeCode").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(CreateTokenResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ttl")
            .getter(getter(CreateTokenResponse::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            CHALLENGE_CODE_FIELD, SESSION_ID_FIELD, TTL_FIELD));

    private final String appId;

    private final String challengeCode;

    private final String sessionId;

    private final String ttl;

    private CreateTokenResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.challengeCode = builder.challengeCode;
        this.sessionId = builder.sessionId;
        this.ttl = builder.ttl;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * One-time challenge code for authenticating into the Amplify Admin UI.
     * </p>
     * 
     * @return One-time challenge code for authenticating into the Amplify Admin UI.
     */
    public final String challengeCode() {
        return challengeCode;
    }

    /**
     * <p>
     * A unique ID provided when creating a new challenge token.
     * </p>
     * 
     * @return A unique ID provided when creating a new challenge token.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The expiry time for the one-time generated token code.
     * </p>
     * 
     * @return The expiry time for the one-time generated token code.
     */
    public final String ttl() {
        return ttl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(challengeCode());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenResponse)) {
            return false;
        }
        CreateTokenResponse other = (CreateTokenResponse) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(challengeCode(), other.challengeCode())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(ttl(), other.ttl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTokenResponse").add("AppId", appId()).add("ChallengeCode", challengeCode())
                .add("SessionId", sessionId()).add("Ttl", ttl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "ChallengeCode":
            return Optional.ofNullable(clazz.cast(challengeCode()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenResponse, T> g) {
        return obj -> g.apply((CreateTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyBackendResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTokenResponse> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * One-time challenge code for authenticating into the Amplify Admin UI.
         * </p>
         * 
         * @param challengeCode
         *        One-time challenge code for authenticating into the Amplify Admin UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeCode(String challengeCode);

        /**
         * <p>
         * A unique ID provided when creating a new challenge token.
         * </p>
         * 
         * @param sessionId
         *        A unique ID provided when creating a new challenge token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The expiry time for the one-time generated token code.
         * </p>
         * 
         * @param ttl
         *        The expiry time for the one-time generated token code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(String ttl);
    }

    static final class BuilderImpl extends AmplifyBackendResponse.BuilderImpl implements Builder {
        private String appId;

        private String challengeCode;

        private String sessionId;

        private String ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenResponse model) {
            super(model);
            appId(model.appId);
            challengeCode(model.challengeCode);
            sessionId(model.sessionId);
            ttl(model.ttl);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getChallengeCode() {
            return challengeCode;
        }

        @Override
        public final Builder challengeCode(String challengeCode) {
            this.challengeCode = challengeCode;
            return this;
        }

        public final void setChallengeCode(String challengeCode) {
            this.challengeCode = challengeCode;
        }

        public final String getSessionId() {
            return sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getTtl() {
            return ttl;
        }

        @Override
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        @Override
        public CreateTokenResponse build() {
            return new CreateTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
