/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the resource configuration when creating an auth resource in your Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackendAuthResourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateBackendAuthResourceConfig.Builder, CreateBackendAuthResourceConfig> {
    private static final SdkField<String> AUTH_RESOURCES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthResources").getter(getter(CreateBackendAuthResourceConfig::authResourcesAsString))
            .setter(setter(Builder::authResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authResources").build()).build();

    private static final SdkField<CreateBackendAuthIdentityPoolConfig> IDENTITY_POOL_CONFIGS_FIELD = SdkField
            .<CreateBackendAuthIdentityPoolConfig> builder(MarshallingType.SDK_POJO).memberName("IdentityPoolConfigs")
            .getter(getter(CreateBackendAuthResourceConfig::identityPoolConfigs)).setter(setter(Builder::identityPoolConfigs))
            .constructor(CreateBackendAuthIdentityPoolConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityPoolConfigs").build())
            .build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(CreateBackendAuthResourceConfig::serviceAsString)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<CreateBackendAuthUserPoolConfig> USER_POOL_CONFIGS_FIELD = SdkField
            .<CreateBackendAuthUserPoolConfig> builder(MarshallingType.SDK_POJO).memberName("UserPoolConfigs")
            .getter(getter(CreateBackendAuthResourceConfig::userPoolConfigs)).setter(setter(Builder::userPoolConfigs))
            .constructor(CreateBackendAuthUserPoolConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfigs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_RESOURCES_FIELD,
            IDENTITY_POOL_CONFIGS_FIELD, SERVICE_FIELD, USER_POOL_CONFIGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authResources;

    private final CreateBackendAuthIdentityPoolConfig identityPoolConfigs;

    private final String service;

    private final CreateBackendAuthUserPoolConfig userPoolConfigs;

    private CreateBackendAuthResourceConfig(BuilderImpl builder) {
        this.authResources = builder.authResources;
        this.identityPoolConfigs = builder.identityPoolConfigs;
        this.service = builder.service;
        this.userPoolConfigs = builder.userPoolConfigs;
    }

    /**
     * <p>
     * Defines whether you want to configure only authentication or both authentication and authorization settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authResources}
     * will return {@link AuthResources#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authResourcesAsString}.
     * </p>
     * 
     * @return Defines whether you want to configure only authentication or both authentication and authorization
     *         settings.
     * @see AuthResources
     */
    public final AuthResources authResources() {
        return AuthResources.fromValue(authResources);
    }

    /**
     * <p>
     * Defines whether you want to configure only authentication or both authentication and authorization settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authResources}
     * will return {@link AuthResources#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authResourcesAsString}.
     * </p>
     * 
     * @return Defines whether you want to configure only authentication or both authentication and authorization
     *         settings.
     * @see AuthResources
     */
    public final String authResourcesAsString() {
        return authResources;
    }

    /**
     * <p>
     * Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of the auth
     * resource in your Amplify project.
     * </p>
     * 
     * @return Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of
     *         the auth resource in your Amplify project.
     */
    public final CreateBackendAuthIdentityPoolConfig identityPoolConfigs() {
        return identityPoolConfigs;
    }

    /**
     * <p>
     * Defines the service name to use when configuring an authentication resource in your Amplify project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link Service#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceAsString}.
     * </p>
     * 
     * @return Defines the service name to use when configuring an authentication resource in your Amplify project.
     * @see Service
     */
    public final Service service() {
        return Service.fromValue(service);
    }

    /**
     * <p>
     * Defines the service name to use when configuring an authentication resource in your Amplify project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #service} will
     * return {@link Service#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceAsString}.
     * </p>
     * 
     * @return Defines the service name to use when configuring an authentication resource in your Amplify project.
     * @see Service
     */
    public final String serviceAsString() {
        return service;
    }

    /**
     * <p>
     * Describes the authentication configuration for the Amazon Cognito user pool, provisioned as a part of the auth
     * resource in your Amplify project.
     * </p>
     * 
     * @return Describes the authentication configuration for the Amazon Cognito user pool, provisioned as a part of the
     *         auth resource in your Amplify project.
     */
    public final CreateBackendAuthUserPoolConfig userPoolConfigs() {
        return userPoolConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authResourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolConfigs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthResourceConfig)) {
            return false;
        }
        CreateBackendAuthResourceConfig other = (CreateBackendAuthResourceConfig) obj;
        return Objects.equals(authResourcesAsString(), other.authResourcesAsString())
                && Objects.equals(identityPoolConfigs(), other.identityPoolConfigs())
                && Objects.equals(serviceAsString(), other.serviceAsString())
                && Objects.equals(userPoolConfigs(), other.userPoolConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackendAuthResourceConfig").add("AuthResources", authResourcesAsString())
                .add("IdentityPoolConfigs", identityPoolConfigs()).add("Service", serviceAsString())
                .add("UserPoolConfigs", userPoolConfigs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthResources":
            return Optional.ofNullable(clazz.cast(authResourcesAsString()));
        case "IdentityPoolConfigs":
            return Optional.ofNullable(clazz.cast(identityPoolConfigs()));
        case "Service":
            return Optional.ofNullable(clazz.cast(serviceAsString()));
        case "UserPoolConfigs":
            return Optional.ofNullable(clazz.cast(userPoolConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthResourceConfig, T> g) {
        return obj -> g.apply((CreateBackendAuthResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateBackendAuthResourceConfig> {
        /**
         * <p>
         * Defines whether you want to configure only authentication or both authentication and authorization settings.
         * </p>
         * 
         * @param authResources
         *        Defines whether you want to configure only authentication or both authentication and authorization
         *        settings.
         * @see AuthResources
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthResources
         */
        Builder authResources(String authResources);

        /**
         * <p>
         * Defines whether you want to configure only authentication or both authentication and authorization settings.
         * </p>
         * 
         * @param authResources
         *        Defines whether you want to configure only authentication or both authentication and authorization
         *        settings.
         * @see AuthResources
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthResources
         */
        Builder authResources(AuthResources authResources);

        /**
         * <p>
         * Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of the
         * auth resource in your Amplify project.
         * </p>
         * 
         * @param identityPoolConfigs
         *        Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part
         *        of the auth resource in your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolConfigs(CreateBackendAuthIdentityPoolConfig identityPoolConfigs);

        /**
         * <p>
         * Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of the
         * auth resource in your Amplify project.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateBackendAuthIdentityPoolConfig.Builder}
         * avoiding the need to create one manually via {@link CreateBackendAuthIdentityPoolConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateBackendAuthIdentityPoolConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #identityPoolConfigs(CreateBackendAuthIdentityPoolConfig)}.
         * 
         * @param identityPoolConfigs
         *        a consumer that will call methods on {@link CreateBackendAuthIdentityPoolConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityPoolConfigs(CreateBackendAuthIdentityPoolConfig)
         */
        default Builder identityPoolConfigs(Consumer<CreateBackendAuthIdentityPoolConfig.Builder> identityPoolConfigs) {
            return identityPoolConfigs(CreateBackendAuthIdentityPoolConfig.builder().applyMutation(identityPoolConfigs).build());
        }

        /**
         * <p>
         * Defines the service name to use when configuring an authentication resource in your Amplify project.
         * </p>
         * 
         * @param service
         *        Defines the service name to use when configuring an authentication resource in your Amplify project.
         * @see Service
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Service
         */
        Builder service(String service);

        /**
         * <p>
         * Defines the service name to use when configuring an authentication resource in your Amplify project.
         * </p>
         * 
         * @param service
         *        Defines the service name to use when configuring an authentication resource in your Amplify project.
         * @see Service
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Service
         */
        Builder service(Service service);

        /**
         * <p>
         * Describes the authentication configuration for the Amazon Cognito user pool, provisioned as a part of the
         * auth resource in your Amplify project.
         * </p>
         * 
         * @param userPoolConfigs
         *        Describes the authentication configuration for the Amazon Cognito user pool, provisioned as a part of
         *        the auth resource in your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolConfigs(CreateBackendAuthUserPoolConfig userPoolConfigs);

        /**
         * <p>
         * Describes the authentication configuration for the Amazon Cognito user pool, provisioned as a part of the
         * auth resource in your Amplify project.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateBackendAuthUserPoolConfig.Builder}
         * avoiding the need to create one manually via {@link CreateBackendAuthUserPoolConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateBackendAuthUserPoolConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #userPoolConfigs(CreateBackendAuthUserPoolConfig)}.
         * 
         * @param userPoolConfigs
         *        a consumer that will call methods on {@link CreateBackendAuthUserPoolConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolConfigs(CreateBackendAuthUserPoolConfig)
         */
        default Builder userPoolConfigs(Consumer<CreateBackendAuthUserPoolConfig.Builder> userPoolConfigs) {
            return userPoolConfigs(CreateBackendAuthUserPoolConfig.builder().applyMutation(userPoolConfigs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authResources;

        private CreateBackendAuthIdentityPoolConfig identityPoolConfigs;

        private String service;

        private CreateBackendAuthUserPoolConfig userPoolConfigs;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthResourceConfig model) {
            authResources(model.authResources);
            identityPoolConfigs(model.identityPoolConfigs);
            service(model.service);
            userPoolConfigs(model.userPoolConfigs);
        }

        public final String getAuthResources() {
            return authResources;
        }

        @Override
        public final Builder authResources(String authResources) {
            this.authResources = authResources;
            return this;
        }

        @Override
        public final Builder authResources(AuthResources authResources) {
            this.authResources(authResources == null ? null : authResources.toString());
            return this;
        }

        public final void setAuthResources(String authResources) {
            this.authResources = authResources;
        }

        public final CreateBackendAuthIdentityPoolConfig.Builder getIdentityPoolConfigs() {
            return identityPoolConfigs != null ? identityPoolConfigs.toBuilder() : null;
        }

        @Override
        public final Builder identityPoolConfigs(CreateBackendAuthIdentityPoolConfig identityPoolConfigs) {
            this.identityPoolConfigs = identityPoolConfigs;
            return this;
        }

        public final void setIdentityPoolConfigs(CreateBackendAuthIdentityPoolConfig.BuilderImpl identityPoolConfigs) {
            this.identityPoolConfigs = identityPoolConfigs != null ? identityPoolConfigs.build() : null;
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(Service service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final CreateBackendAuthUserPoolConfig.Builder getUserPoolConfigs() {
            return userPoolConfigs != null ? userPoolConfigs.toBuilder() : null;
        }

        @Override
        public final Builder userPoolConfigs(CreateBackendAuthUserPoolConfig userPoolConfigs) {
            this.userPoolConfigs = userPoolConfigs;
            return this;
        }

        public final void setUserPoolConfigs(CreateBackendAuthUserPoolConfig.BuilderImpl userPoolConfigs) {
            this.userPoolConfigs = userPoolConfigs != null ? userPoolConfigs.build() : null;
        }

        @Override
        public CreateBackendAuthResourceConfig build() {
            return new CreateBackendAuthResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
