/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackendEnvironmentRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, GetBackendEnvironmentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(GetBackendEnvironmentRequest.getter(GetBackendEnvironmentRequest::appId)).setter(GetBackendEnvironmentRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(GetBackendEnvironmentRequest.getter(GetBackendEnvironmentRequest::environmentName)).setter(GetBackendEnvironmentRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ENVIRONMENT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBackendEnvironmentRequest.memberNameToFieldInitializer();
    private final String appId;
    private final String environmentName;

    private GetBackendEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
    }

    public final String appId() {
        return this.appId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackendEnvironmentRequest)) {
            return false;
        }
        GetBackendEnvironmentRequest other = (GetBackendEnvironmentRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.environmentName(), other.environmentName());
    }

    public final String toString() {
        return ToString.builder((String)"GetBackendEnvironmentRequest").add("AppId", (Object)this.appId()).add("EnvironmentName", (Object)this.environmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("appId", APP_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBackendEnvironmentRequest, T> g) {
        return obj -> g.apply((GetBackendEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String environmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackendEnvironmentRequest model) {
            super(model);
            this.appId(model.appId);
            this.environmentName(model.environmentName);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBackendEnvironmentRequest build() {
            return new GetBackendEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackendEnvironmentRequest> {
        public Builder appId(String var1);

        public Builder environmentName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

