/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.services.amplify.model.AutoSubDomainCreationPatternsCopier;
import software.amazon.awssdk.services.amplify.model.CertificateSettings;
import software.amazon.awssdk.services.amplify.model.SubDomainSetting;
import software.amazon.awssdk.services.amplify.model.SubDomainSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainAssociationRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, UpdateDomainAssociationRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::appId)).setter(UpdateDomainAssociationRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::domainName)).setter(UpdateDomainAssociationRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_SUB_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableAutoSubDomain").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::enableAutoSubDomain)).setter(UpdateDomainAssociationRequest.setter(Builder::enableAutoSubDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoSubDomain").build()}).build();
    private static final SdkField<List<SubDomainSetting>> SUB_DOMAIN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subDomainSettings").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::subDomainSettings)).setter(UpdateDomainAssociationRequest.setter(Builder::subDomainSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subDomainSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubDomainSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTO_SUB_DOMAIN_CREATION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoSubDomainCreationPatterns").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::autoSubDomainCreationPatterns)).setter(UpdateDomainAssociationRequest.setter(Builder::autoSubDomainCreationPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubDomainCreationPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTO_SUB_DOMAIN_IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoSubDomainIAMRole").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::autoSubDomainIAMRole)).setter(UpdateDomainAssociationRequest.setter(Builder::autoSubDomainIAMRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubDomainIAMRole").build()}).build();
    private static final SdkField<CertificateSettings> CERTIFICATE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificateSettings").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::certificateSettings)).setter(UpdateDomainAssociationRequest.setter(Builder::certificateSettings)).constructor(CertificateSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, DOMAIN_NAME_FIELD, ENABLE_AUTO_SUB_DOMAIN_FIELD, SUB_DOMAIN_SETTINGS_FIELD, AUTO_SUB_DOMAIN_CREATION_PATTERNS_FIELD, AUTO_SUB_DOMAIN_IAM_ROLE_FIELD, CERTIFICATE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDomainAssociationRequest.memberNameToFieldInitializer();
    private final String appId;
    private final String domainName;
    private final Boolean enableAutoSubDomain;
    private final List<SubDomainSetting> subDomainSettings;
    private final List<String> autoSubDomainCreationPatterns;
    private final String autoSubDomainIAMRole;
    private final CertificateSettings certificateSettings;

    private UpdateDomainAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.domainName = builder.domainName;
        this.enableAutoSubDomain = builder.enableAutoSubDomain;
        this.subDomainSettings = builder.subDomainSettings;
        this.autoSubDomainCreationPatterns = builder.autoSubDomainCreationPatterns;
        this.autoSubDomainIAMRole = builder.autoSubDomainIAMRole;
        this.certificateSettings = builder.certificateSettings;
    }

    public final String appId() {
        return this.appId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Boolean enableAutoSubDomain() {
        return this.enableAutoSubDomain;
    }

    public final boolean hasSubDomainSettings() {
        return this.subDomainSettings != null && !(this.subDomainSettings instanceof SdkAutoConstructList);
    }

    public final List<SubDomainSetting> subDomainSettings() {
        return this.subDomainSettings;
    }

    public final boolean hasAutoSubDomainCreationPatterns() {
        return this.autoSubDomainCreationPatterns != null && !(this.autoSubDomainCreationPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> autoSubDomainCreationPatterns() {
        return this.autoSubDomainCreationPatterns;
    }

    public final String autoSubDomainIAMRole() {
        return this.autoSubDomainIAMRole;
    }

    public final CertificateSettings certificateSettings() {
        return this.certificateSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoSubDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubDomainSettings() ? this.subDomainSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoSubDomainCreationPatterns() ? this.autoSubDomainCreationPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoSubDomainIAMRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainAssociationRequest)) {
            return false;
        }
        UpdateDomainAssociationRequest other = (UpdateDomainAssociationRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.enableAutoSubDomain(), other.enableAutoSubDomain()) && this.hasSubDomainSettings() == other.hasSubDomainSettings() && Objects.equals(this.subDomainSettings(), other.subDomainSettings()) && this.hasAutoSubDomainCreationPatterns() == other.hasAutoSubDomainCreationPatterns() && Objects.equals(this.autoSubDomainCreationPatterns(), other.autoSubDomainCreationPatterns()) && Objects.equals(this.autoSubDomainIAMRole(), other.autoSubDomainIAMRole()) && Objects.equals(this.certificateSettings(), other.certificateSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainAssociationRequest").add("AppId", (Object)this.appId()).add("DomainName", (Object)this.domainName()).add("EnableAutoSubDomain", (Object)this.enableAutoSubDomain()).add("SubDomainSettings", this.hasSubDomainSettings() ? this.subDomainSettings() : null).add("AutoSubDomainCreationPatterns", this.hasAutoSubDomainCreationPatterns() ? this.autoSubDomainCreationPatterns() : null).add("AutoSubDomainIAMRole", (Object)this.autoSubDomainIAMRole()).add("CertificateSettings", (Object)this.certificateSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "enableAutoSubDomain": {
                return Optional.ofNullable(clazz.cast(this.enableAutoSubDomain()));
            }
            case "subDomainSettings": {
                return Optional.ofNullable(clazz.cast(this.subDomainSettings()));
            }
            case "autoSubDomainCreationPatterns": {
                return Optional.ofNullable(clazz.cast(this.autoSubDomainCreationPatterns()));
            }
            case "autoSubDomainIAMRole": {
                return Optional.ofNullable(clazz.cast(this.autoSubDomainIAMRole()));
            }
            case "certificateSettings": {
                return Optional.ofNullable(clazz.cast(this.certificateSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", APP_ID_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("enableAutoSubDomain", ENABLE_AUTO_SUB_DOMAIN_FIELD);
        map.put("subDomainSettings", SUB_DOMAIN_SETTINGS_FIELD);
        map.put("autoSubDomainCreationPatterns", AUTO_SUB_DOMAIN_CREATION_PATTERNS_FIELD);
        map.put("autoSubDomainIAMRole", AUTO_SUB_DOMAIN_IAM_ROLE_FIELD);
        map.put("certificateSettings", CERTIFICATE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainAssociationRequest, T> g) {
        return obj -> g.apply((UpdateDomainAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String domainName;
        private Boolean enableAutoSubDomain;
        private List<SubDomainSetting> subDomainSettings = DefaultSdkAutoConstructList.getInstance();
        private List<String> autoSubDomainCreationPatterns = DefaultSdkAutoConstructList.getInstance();
        private String autoSubDomainIAMRole;
        private CertificateSettings certificateSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainAssociationRequest model) {
            super(model);
            this.appId(model.appId);
            this.domainName(model.domainName);
            this.enableAutoSubDomain(model.enableAutoSubDomain);
            this.subDomainSettings(model.subDomainSettings);
            this.autoSubDomainCreationPatterns(model.autoSubDomainCreationPatterns);
            this.autoSubDomainIAMRole(model.autoSubDomainIAMRole);
            this.certificateSettings(model.certificateSettings);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Boolean getEnableAutoSubDomain() {
            return this.enableAutoSubDomain;
        }

        public final void setEnableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
        }

        @Override
        public final Builder enableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
            return this;
        }

        public final List<SubDomainSetting.Builder> getSubDomainSettings() {
            List<SubDomainSetting.Builder> result = SubDomainSettingsCopier.copyToBuilder(this.subDomainSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubDomainSettings(Collection<SubDomainSetting.BuilderImpl> subDomainSettings) {
            this.subDomainSettings = SubDomainSettingsCopier.copyFromBuilder(subDomainSettings);
        }

        @Override
        public final Builder subDomainSettings(Collection<SubDomainSetting> subDomainSettings) {
            this.subDomainSettings = SubDomainSettingsCopier.copy(subDomainSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDomainSettings(SubDomainSetting ... subDomainSettings) {
            this.subDomainSettings(Arrays.asList(subDomainSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDomainSettings(Consumer<SubDomainSetting.Builder> ... subDomainSettings) {
            this.subDomainSettings(Stream.of(subDomainSettings).map(c -> (SubDomainSetting)((SubDomainSetting.Builder)SubDomainSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAutoSubDomainCreationPatterns() {
            if (this.autoSubDomainCreationPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoSubDomainCreationPatterns;
        }

        public final void setAutoSubDomainCreationPatterns(Collection<String> autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns = AutoSubDomainCreationPatternsCopier.copy(autoSubDomainCreationPatterns);
        }

        @Override
        public final Builder autoSubDomainCreationPatterns(Collection<String> autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns = AutoSubDomainCreationPatternsCopier.copy(autoSubDomainCreationPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoSubDomainCreationPatterns(String ... autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns(Arrays.asList(autoSubDomainCreationPatterns));
            return this;
        }

        public final String getAutoSubDomainIAMRole() {
            return this.autoSubDomainIAMRole;
        }

        public final void setAutoSubDomainIAMRole(String autoSubDomainIAMRole) {
            this.autoSubDomainIAMRole = autoSubDomainIAMRole;
        }

        @Override
        public final Builder autoSubDomainIAMRole(String autoSubDomainIAMRole) {
            this.autoSubDomainIAMRole = autoSubDomainIAMRole;
            return this;
        }

        public final CertificateSettings.Builder getCertificateSettings() {
            return this.certificateSettings != null ? this.certificateSettings.toBuilder() : null;
        }

        public final void setCertificateSettings(CertificateSettings.BuilderImpl certificateSettings) {
            this.certificateSettings = certificateSettings != null ? certificateSettings.build() : null;
        }

        @Override
        public final Builder certificateSettings(CertificateSettings certificateSettings) {
            this.certificateSettings = certificateSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainAssociationRequest build() {
            return new UpdateDomainAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainAssociationRequest> {
        public Builder appId(String var1);

        public Builder domainName(String var1);

        public Builder enableAutoSubDomain(Boolean var1);

        public Builder subDomainSettings(Collection<SubDomainSetting> var1);

        public Builder subDomainSettings(SubDomainSetting ... var1);

        public Builder subDomainSettings(Consumer<SubDomainSetting.Builder> ... var1);

        public Builder autoSubDomainCreationPatterns(Collection<String> var1);

        public Builder autoSubDomainCreationPatterns(String ... var1);

        public Builder autoSubDomainIAMRole(String var1);

        public Builder certificateSettings(CertificateSettings var1);

        default public Builder certificateSettings(Consumer<CertificateSettings.Builder> certificateSettings) {
            return this.certificateSettings((CertificateSettings)((CertificateSettings.Builder)CertificateSettings.builder().applyMutation(certificateSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

