/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig;
import software.amazon.awssdk.services.amplify.model.AutoBranchCreationPatternsCopier;
import software.amazon.awssdk.services.amplify.model.CustomRule;
import software.amazon.awssdk.services.amplify.model.CustomRulesCopier;
import software.amazon.awssdk.services.amplify.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.amplify.model.Platform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAppRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, UpdateAppRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::appId)).setter(UpdateAppRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::name)).setter(UpdateAppRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::description)).setter(UpdateAppRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::platformAsString)).setter(UpdateAppRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::iamServiceRoleArn)).setter(UpdateAppRequest.setter(Builder::iamServiceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateAppRequest.getter(UpdateAppRequest::environmentVariables)).setter(UpdateAppRequest.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateAppRequest.getter(UpdateAppRequest::enableBranchAutoBuild)).setter(UpdateAppRequest.setter(Builder::enableBranchAutoBuild)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build()}).build();
    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateAppRequest.getter(UpdateAppRequest::enableBranchAutoDeletion)).setter(UpdateAppRequest.setter(Builder::enableBranchAutoDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoDeletion").build()}).build();
    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateAppRequest.getter(UpdateAppRequest::enableBasicAuth)).setter(UpdateAppRequest.setter(Builder::enableBasicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()}).build();
    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::basicAuthCredentials)).setter(UpdateAppRequest.setter(Builder::basicAuthCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build()}).build();
    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateAppRequest.getter(UpdateAppRequest::customRules)).setter(UpdateAppRequest.setter(Builder::customRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::buildSpec)).setter(UpdateAppRequest.setter(Builder::buildSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_BRANCH_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateAppRequest.getter(UpdateAppRequest::enableAutoBranchCreation)).setter(UpdateAppRequest.setter(Builder::enableAutoBranchCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBranchCreation").build()}).build();
    private static final SdkField<List<String>> AUTO_BRANCH_CREATION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateAppRequest.getter(UpdateAppRequest::autoBranchCreationPatterns)).setter(UpdateAppRequest.setter(Builder::autoBranchCreationPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoBranchCreationConfig> AUTO_BRANCH_CREATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateAppRequest.getter(UpdateAppRequest::autoBranchCreationConfig)).setter(UpdateAppRequest.setter(Builder::autoBranchCreationConfig)).constructor(AutoBranchCreationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationConfig").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::repository)).setter(UpdateAppRequest.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()}).build();
    private static final SdkField<String> OAUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::oauthToken)).setter(UpdateAppRequest.setter(Builder::oauthToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthToken").build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAppRequest.getter(UpdateAppRequest::accessToken)).setter(UpdateAppRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PLATFORM_FIELD, IAM_SERVICE_ROLE_ARN_FIELD, ENVIRONMENT_VARIABLES_FIELD, ENABLE_BRANCH_AUTO_BUILD_FIELD, ENABLE_BRANCH_AUTO_DELETION_FIELD, ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD, BUILD_SPEC_FIELD, ENABLE_AUTO_BRANCH_CREATION_FIELD, AUTO_BRANCH_CREATION_PATTERNS_FIELD, AUTO_BRANCH_CREATION_CONFIG_FIELD, REPOSITORY_FIELD, OAUTH_TOKEN_FIELD, ACCESS_TOKEN_FIELD));
    private final String appId;
    private final String name;
    private final String description;
    private final String platform;
    private final String iamServiceRoleArn;
    private final Map<String, String> environmentVariables;
    private final Boolean enableBranchAutoBuild;
    private final Boolean enableBranchAutoDeletion;
    private final Boolean enableBasicAuth;
    private final String basicAuthCredentials;
    private final List<CustomRule> customRules;
    private final String buildSpec;
    private final Boolean enableAutoBranchCreation;
    private final List<String> autoBranchCreationPatterns;
    private final AutoBranchCreationConfig autoBranchCreationConfig;
    private final String repository;
    private final String oauthToken;
    private final String accessToken;

    private UpdateAppRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.name = builder.name;
        this.description = builder.description;
        this.platform = builder.platform;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.environmentVariables = builder.environmentVariables;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBranchAutoDeletion = builder.enableBranchAutoDeletion;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.buildSpec = builder.buildSpec;
        this.enableAutoBranchCreation = builder.enableAutoBranchCreation;
        this.autoBranchCreationPatterns = builder.autoBranchCreationPatterns;
        this.autoBranchCreationConfig = builder.autoBranchCreationConfig;
        this.repository = builder.repository;
        this.oauthToken = builder.oauthToken;
        this.accessToken = builder.accessToken;
    }

    public String appId() {
        return this.appId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public String iamServiceRoleArn() {
        return this.iamServiceRoleArn;
    }

    public boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public Boolean enableBranchAutoBuild() {
        return this.enableBranchAutoBuild;
    }

    public Boolean enableBranchAutoDeletion() {
        return this.enableBranchAutoDeletion;
    }

    public Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public String basicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public boolean hasCustomRules() {
        return this.customRules != null && !(this.customRules instanceof SdkAutoConstructList);
    }

    public List<CustomRule> customRules() {
        return this.customRules;
    }

    public String buildSpec() {
        return this.buildSpec;
    }

    public Boolean enableAutoBranchCreation() {
        return this.enableAutoBranchCreation;
    }

    public boolean hasAutoBranchCreationPatterns() {
        return this.autoBranchCreationPatterns != null && !(this.autoBranchCreationPatterns instanceof SdkAutoConstructList);
    }

    public List<String> autoBranchCreationPatterns() {
        return this.autoBranchCreationPatterns;
    }

    public AutoBranchCreationConfig autoBranchCreationConfig() {
        return this.autoBranchCreationConfig;
    }

    public String repository() {
        return this.repository;
    }

    public String oauthToken() {
        return this.oauthToken;
    }

    public String accessToken() {
        return this.accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBranchAutoDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.customRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoBranchCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoBranchCreationPatterns());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoBranchCreationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.oauthToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppRequest)) {
            return false;
        }
        UpdateAppRequest other = (UpdateAppRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.iamServiceRoleArn(), other.iamServiceRoleArn()) && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.enableBranchAutoBuild(), other.enableBranchAutoBuild()) && Objects.equals(this.enableBranchAutoDeletion(), other.enableBranchAutoDeletion()) && Objects.equals(this.enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(this.basicAuthCredentials(), other.basicAuthCredentials()) && Objects.equals(this.customRules(), other.customRules()) && Objects.equals(this.buildSpec(), other.buildSpec()) && Objects.equals(this.enableAutoBranchCreation(), other.enableAutoBranchCreation()) && Objects.equals(this.autoBranchCreationPatterns(), other.autoBranchCreationPatterns()) && Objects.equals(this.autoBranchCreationConfig(), other.autoBranchCreationConfig()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.oauthToken(), other.oauthToken()) && Objects.equals(this.accessToken(), other.accessToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAppRequest").add("AppId", (Object)this.appId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Platform", (Object)this.platformAsString()).add("IamServiceRoleArn", (Object)this.iamServiceRoleArn()).add("EnvironmentVariables", this.environmentVariables()).add("EnableBranchAutoBuild", (Object)this.enableBranchAutoBuild()).add("EnableBranchAutoDeletion", (Object)this.enableBranchAutoDeletion()).add("EnableBasicAuth", (Object)this.enableBasicAuth()).add("BasicAuthCredentials", (Object)(this.basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("CustomRules", this.customRules()).add("BuildSpec", (Object)this.buildSpec()).add("EnableAutoBranchCreation", (Object)this.enableAutoBranchCreation()).add("AutoBranchCreationPatterns", this.autoBranchCreationPatterns()).add("AutoBranchCreationConfig", (Object)this.autoBranchCreationConfig()).add("Repository", (Object)this.repository()).add("OauthToken", (Object)(this.oauthToken() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "iamServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamServiceRoleArn()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "enableBranchAutoBuild": {
                return Optional.ofNullable(clazz.cast(this.enableBranchAutoBuild()));
            }
            case "enableBranchAutoDeletion": {
                return Optional.ofNullable(clazz.cast(this.enableBranchAutoDeletion()));
            }
            case "enableBasicAuth": {
                return Optional.ofNullable(clazz.cast(this.enableBasicAuth()));
            }
            case "basicAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthCredentials()));
            }
            case "customRules": {
                return Optional.ofNullable(clazz.cast(this.customRules()));
            }
            case "buildSpec": {
                return Optional.ofNullable(clazz.cast(this.buildSpec()));
            }
            case "enableAutoBranchCreation": {
                return Optional.ofNullable(clazz.cast(this.enableAutoBranchCreation()));
            }
            case "autoBranchCreationPatterns": {
                return Optional.ofNullable(clazz.cast(this.autoBranchCreationPatterns()));
            }
            case "autoBranchCreationConfig": {
                return Optional.ofNullable(clazz.cast(this.autoBranchCreationConfig()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "oauthToken": {
                return Optional.ofNullable(clazz.cast(this.oauthToken()));
            }
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppRequest, T> g) {
        return obj -> g.apply((UpdateAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String name;
        private String description;
        private String platform;
        private String iamServiceRoleArn;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private Boolean enableBranchAutoBuild;
        private Boolean enableBranchAutoDeletion;
        private Boolean enableBasicAuth;
        private String basicAuthCredentials;
        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();
        private String buildSpec;
        private Boolean enableAutoBranchCreation;
        private List<String> autoBranchCreationPatterns = DefaultSdkAutoConstructList.getInstance();
        private AutoBranchCreationConfig autoBranchCreationConfig;
        private String repository;
        private String oauthToken;
        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppRequest model) {
            super(model);
            this.appId(model.appId);
            this.name(model.name);
            this.description(model.description);
            this.platform(model.platform);
            this.iamServiceRoleArn(model.iamServiceRoleArn);
            this.environmentVariables(model.environmentVariables);
            this.enableBranchAutoBuild(model.enableBranchAutoBuild);
            this.enableBranchAutoDeletion(model.enableBranchAutoDeletion);
            this.enableBasicAuth(model.enableBasicAuth);
            this.basicAuthCredentials(model.basicAuthCredentials);
            this.customRules(model.customRules);
            this.buildSpec(model.buildSpec);
            this.enableAutoBranchCreation(model.enableAutoBranchCreation);
            this.autoBranchCreationPatterns(model.autoBranchCreationPatterns);
            this.autoBranchCreationConfig(model.autoBranchCreationConfig);
            this.repository(model.repository);
            this.oauthToken(model.oauthToken);
            this.accessToken(model.accessToken);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getIamServiceRoleArn() {
            return this.iamServiceRoleArn;
        }

        @Override
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final Boolean getEnableBranchAutoBuild() {
            return this.enableBranchAutoBuild;
        }

        @Override
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        public final Boolean getEnableBranchAutoDeletion() {
            return this.enableBranchAutoDeletion;
        }

        @Override
        public final Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
            return this;
        }

        public final void setEnableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
        }

        public final Boolean getEnableBasicAuth() {
            return this.enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final String getBasicAuthCredentials() {
            return this.basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final Collection<CustomRule.Builder> getCustomRules() {
            return this.customRules != null ? (Collection)this.customRules.stream().map(CustomRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(CustomRule ... customRules) {
            this.customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder> ... customRules) {
            this.customRules(Stream.of(customRules).map(c -> (CustomRule)((CustomRule.Builder)CustomRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        public final String getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        public final Boolean getEnableAutoBranchCreation() {
            return this.enableAutoBranchCreation;
        }

        @Override
        public final Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
            return this;
        }

        public final void setEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
        }

        public final Collection<String> getAutoBranchCreationPatterns() {
            return this.autoBranchCreationPatterns;
        }

        @Override
        public final Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoBranchCreationPatterns(String ... autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns(Arrays.asList(autoBranchCreationPatterns));
            return this;
        }

        public final void setAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
        }

        public final AutoBranchCreationConfig.Builder getAutoBranchCreationConfig() {
            return this.autoBranchCreationConfig != null ? this.autoBranchCreationConfig.toBuilder() : null;
        }

        @Override
        public final Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        public final void setAutoBranchCreationConfig(AutoBranchCreationConfig.BuilderImpl autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig != null ? autoBranchCreationConfig.build() : null;
        }

        public final String getRepository() {
            return this.repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getOauthToken() {
            return this.oauthToken;
        }

        @Override
        public final Builder oauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        public final void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppRequest build() {
            return new UpdateAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAppRequest> {
        public Builder appId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder iamServiceRoleArn(String var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder enableBranchAutoBuild(Boolean var1);

        public Builder enableBranchAutoDeletion(Boolean var1);

        public Builder enableBasicAuth(Boolean var1);

        public Builder basicAuthCredentials(String var1);

        public Builder customRules(Collection<CustomRule> var1);

        public Builder customRules(CustomRule ... var1);

        public Builder customRules(Consumer<CustomRule.Builder> ... var1);

        public Builder buildSpec(String var1);

        public Builder enableAutoBranchCreation(Boolean var1);

        public Builder autoBranchCreationPatterns(Collection<String> var1);

        public Builder autoBranchCreationPatterns(String ... var1);

        public Builder autoBranchCreationConfig(AutoBranchCreationConfig var1);

        default public Builder autoBranchCreationConfig(Consumer<AutoBranchCreationConfig.Builder> autoBranchCreationConfig) {
            return this.autoBranchCreationConfig((AutoBranchCreationConfig)((AutoBranchCreationConfig.Builder)AutoBranchCreationConfig.builder().applyMutation(autoBranchCreationConfig)).build());
        }

        public Builder repository(String var1);

        public Builder oauthToken(String var1);

        public Builder accessToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

