/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure for webhook, which associates a webhook with an Amplify App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Webhook implements SdkPojo, Serializable, ToCopyableBuilder<Webhook.Builder, Webhook> {
    private static final SdkField<String> WEBHOOK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Webhook::webhookArn)).setter(setter(Builder::webhookArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookArn").build()).build();

    private static final SdkField<String> WEBHOOK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Webhook::webhookId)).setter(setter(Builder::webhookId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookId").build()).build();

    private static final SdkField<String> WEBHOOK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Webhook::webhookUrl)).setter(setter(Builder::webhookUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhookUrl").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Webhook::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Webhook::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Webhook::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Webhook::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOK_ARN_FIELD,
            WEBHOOK_ID_FIELD, WEBHOOK_URL_FIELD, BRANCH_NAME_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String webhookArn;

    private final String webhookId;

    private final String webhookUrl;

    private final String branchName;

    private final String description;

    private final Instant createTime;

    private final Instant updateTime;

    private Webhook(BuilderImpl builder) {
        this.webhookArn = builder.webhookArn;
        this.webhookId = builder.webhookId;
        this.webhookUrl = builder.webhookUrl;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * ARN for the webhook.
     * </p>
     * 
     * @return ARN for the webhook.
     */
    public String webhookArn() {
        return webhookArn;
    }

    /**
     * <p>
     * Id of the webhook.
     * </p>
     * 
     * @return Id of the webhook.
     */
    public String webhookId() {
        return webhookId;
    }

    /**
     * <p>
     * Url of the webhook.
     * </p>
     * 
     * @return Url of the webhook.
     */
    public String webhookUrl() {
        return webhookUrl;
    }

    /**
     * <p>
     * Name for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Name for a branch, part of an Amplify App.
     */
    public String branchName() {
        return branchName;
    }

    /**
     * <p>
     * Description for a webhook.
     * </p>
     * 
     * @return Description for a webhook.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Create date / time for a webhook.
     * </p>
     * 
     * @return Create date / time for a webhook.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Update date / time for a webhook.
     * </p>
     * 
     * @return Update date / time for a webhook.
     */
    public Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webhookArn());
        hashCode = 31 * hashCode + Objects.hashCode(webhookId());
        hashCode = 31 * hashCode + Objects.hashCode(webhookUrl());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Webhook)) {
            return false;
        }
        Webhook other = (Webhook) obj;
        return Objects.equals(webhookArn(), other.webhookArn()) && Objects.equals(webhookId(), other.webhookId())
                && Objects.equals(webhookUrl(), other.webhookUrl()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(description(), other.description()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Webhook").add("WebhookArn", webhookArn()).add("WebhookId", webhookId())
                .add("WebhookUrl", webhookUrl()).add("BranchName", branchName()).add("Description", description())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webhookArn":
            return Optional.ofNullable(clazz.cast(webhookArn()));
        case "webhookId":
            return Optional.ofNullable(clazz.cast(webhookId()));
        case "webhookUrl":
            return Optional.ofNullable(clazz.cast(webhookUrl()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Webhook, T> g) {
        return obj -> g.apply((Webhook) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Webhook> {
        /**
         * <p>
         * ARN for the webhook.
         * </p>
         * 
         * @param webhookArn
         *        ARN for the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookArn(String webhookArn);

        /**
         * <p>
         * Id of the webhook.
         * </p>
         * 
         * @param webhookId
         *        Id of the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookId(String webhookId);

        /**
         * <p>
         * Url of the webhook.
         * </p>
         * 
         * @param webhookUrl
         *        Url of the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookUrl(String webhookUrl);

        /**
         * <p>
         * Name for a branch, part of an Amplify App.
         * </p>
         * 
         * @param branchName
         *        Name for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * Description for a webhook.
         * </p>
         * 
         * @param description
         *        Description for a webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Create date / time for a webhook.
         * </p>
         * 
         * @param createTime
         *        Create date / time for a webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Update date / time for a webhook.
         * </p>
         * 
         * @param updateTime
         *        Update date / time for a webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String webhookArn;

        private String webhookId;

        private String webhookUrl;

        private String branchName;

        private String description;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Webhook model) {
            webhookArn(model.webhookArn);
            webhookId(model.webhookId);
            webhookUrl(model.webhookUrl);
            branchName(model.branchName);
            description(model.description);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getWebhookArn() {
            return webhookArn;
        }

        @Override
        public final Builder webhookArn(String webhookArn) {
            this.webhookArn = webhookArn;
            return this;
        }

        public final void setWebhookArn(String webhookArn) {
            this.webhookArn = webhookArn;
        }

        public final String getWebhookId() {
            return webhookId;
        }

        @Override
        public final Builder webhookId(String webhookId) {
            this.webhookId = webhookId;
            return this;
        }

        public final void setWebhookId(String webhookId) {
            this.webhookId = webhookId;
        }

        public final String getWebhookUrl() {
            return webhookUrl;
        }

        @Override
        public final Builder webhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        public final void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        public final String getBranchName() {
            return branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public Webhook build() {
            return new Webhook(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
