/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amp.AmpClient;
import software.amazon.awssdk.services.amp.internal.UserAgentUtils;
import software.amazon.awssdk.services.amp.model.AnomalyDetectorSummary;
import software.amazon.awssdk.services.amp.model.ListAnomalyDetectorsRequest;
import software.amazon.awssdk.services.amp.model.ListAnomalyDetectorsResponse;

public class ListAnomalyDetectorsIterable
implements SdkIterable<ListAnomalyDetectorsResponse> {
    private final AmpClient client;
    private final ListAnomalyDetectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnomalyDetectorsIterable(AmpClient client, ListAnomalyDetectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnomalyDetectorsResponseFetcher();
    }

    public Iterator<ListAnomalyDetectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnomalyDetectorSummary> anomalyDetectors() {
        Function<ListAnomalyDetectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalyDetectors() != null) {
                return response.anomalyDetectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnomalyDetectorsResponseFetcher
    implements SyncPageFetcher<ListAnomalyDetectorsResponse> {
        private ListAnomalyDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomalyDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnomalyDetectorsResponse nextPage(ListAnomalyDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListAnomalyDetectorsIterable.this.client.listAnomalyDetectors(ListAnomalyDetectorsIterable.this.firstRequest);
            }
            return ListAnomalyDetectorsIterable.this.client.listAnomalyDetectors((ListAnomalyDetectorsRequest)((Object)ListAnomalyDetectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

