/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.AmpRequest;
import software.amazon.awssdk.services.amp.model.AnomalyDetectorConfiguration;
import software.amazon.awssdk.services.amp.model.AnomalyDetectorMissingDataAction;
import software.amazon.awssdk.services.amp.model.PrometheusMetricLabelMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAnomalyDetectorRequest
extends AmpRequest
implements ToCopyableBuilder<Builder, PutAnomalyDetectorRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(PutAnomalyDetectorRequest.getter(PutAnomalyDetectorRequest::workspaceId)).setter(PutAnomalyDetectorRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyDetectorId").getter(PutAnomalyDetectorRequest.getter(PutAnomalyDetectorRequest::anomalyDetectorId)).setter(PutAnomalyDetectorRequest.setter(Builder::anomalyDetectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("anomalyDetectorId").build()}).build();
    private static final SdkField<Integer> EVALUATION_INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("evaluationIntervalInSeconds").getter(PutAnomalyDetectorRequest.getter(PutAnomalyDetectorRequest::evaluationIntervalInSeconds)).setter(PutAnomalyDetectorRequest.setter(Builder::evaluationIntervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationIntervalInSeconds").build()}).build();
    private static final SdkField<AnomalyDetectorMissingDataAction> MISSING_DATA_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("missingDataAction").getter(PutAnomalyDetectorRequest.getter(PutAnomalyDetectorRequest::missingDataAction)).setter(PutAnomalyDetectorRequest.setter(Builder::missingDataAction)).constructor(AnomalyDetectorMissingDataAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingDataAction").build()}).build();
    private static final SdkField<AnomalyDetectorConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(PutAnomalyDetectorRequest.getter(PutAnomalyDetectorRequest::configuration)).setter(PutAnomalyDetectorRequest.setter(Builder::configuration)).constructor(AnomalyDetectorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("labels").getter(PutAnomalyDetectorRequest.getter(PutAnomalyDetectorRequest::labels)).setter(PutAnomalyDetectorRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(PutAnomalyDetectorRequest.getter(PutAnomalyDetectorRequest::clientToken)).setter(PutAnomalyDetectorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, ANOMALY_DETECTOR_ID_FIELD, EVALUATION_INTERVAL_IN_SECONDS_FIELD, MISSING_DATA_ACTION_FIELD, CONFIGURATION_FIELD, LABELS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAnomalyDetectorRequest.memberNameToFieldInitializer();
    private final String workspaceId;
    private final String anomalyDetectorId;
    private final Integer evaluationIntervalInSeconds;
    private final AnomalyDetectorMissingDataAction missingDataAction;
    private final AnomalyDetectorConfiguration configuration;
    private final Map<String, String> labels;
    private final String clientToken;

    private PutAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.anomalyDetectorId = builder.anomalyDetectorId;
        this.evaluationIntervalInSeconds = builder.evaluationIntervalInSeconds;
        this.missingDataAction = builder.missingDataAction;
        this.configuration = builder.configuration;
        this.labels = builder.labels;
        this.clientToken = builder.clientToken;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String anomalyDetectorId() {
        return this.anomalyDetectorId;
    }

    public final Integer evaluationIntervalInSeconds() {
        return this.evaluationIntervalInSeconds;
    }

    public final AnomalyDetectorMissingDataAction missingDataAction() {
        return this.missingDataAction;
    }

    public final AnomalyDetectorConfiguration configuration() {
        return this.configuration;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labels() {
        return this.labels;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingDataAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAnomalyDetectorRequest)) {
            return false;
        }
        PutAnomalyDetectorRequest other = (PutAnomalyDetectorRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.anomalyDetectorId(), other.anomalyDetectorId()) && Objects.equals(this.evaluationIntervalInSeconds(), other.evaluationIntervalInSeconds()) && Objects.equals(this.missingDataAction(), other.missingDataAction()) && Objects.equals(this.configuration(), other.configuration()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"PutAnomalyDetectorRequest").add("WorkspaceId", (Object)this.workspaceId()).add("AnomalyDetectorId", (Object)this.anomalyDetectorId()).add("EvaluationIntervalInSeconds", (Object)this.evaluationIntervalInSeconds()).add("MissingDataAction", (Object)this.missingDataAction()).add("Configuration", (Object)this.configuration()).add("Labels", this.hasLabels() ? this.labels() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "anomalyDetectorId": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorId()));
            }
            case "evaluationIntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.evaluationIntervalInSeconds()));
            }
            case "missingDataAction": {
                return Optional.ofNullable(clazz.cast(this.missingDataAction()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("anomalyDetectorId", ANOMALY_DETECTOR_ID_FIELD);
        map.put("evaluationIntervalInSeconds", EVALUATION_INTERVAL_IN_SECONDS_FIELD);
        map.put("missingDataAction", MISSING_DATA_ACTION_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("labels", LABELS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((PutAnomalyDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String anomalyDetectorId;
        private Integer evaluationIntervalInSeconds;
        private AnomalyDetectorMissingDataAction missingDataAction;
        private AnomalyDetectorConfiguration configuration;
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAnomalyDetectorRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.anomalyDetectorId(model.anomalyDetectorId);
            this.evaluationIntervalInSeconds(model.evaluationIntervalInSeconds);
            this.missingDataAction(model.missingDataAction);
            this.configuration(model.configuration);
            this.labels(model.labels);
            this.clientToken(model.clientToken);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getAnomalyDetectorId() {
            return this.anomalyDetectorId;
        }

        public final void setAnomalyDetectorId(String anomalyDetectorId) {
            this.anomalyDetectorId = anomalyDetectorId;
        }

        @Override
        public final Builder anomalyDetectorId(String anomalyDetectorId) {
            this.anomalyDetectorId = anomalyDetectorId;
            return this;
        }

        public final Integer getEvaluationIntervalInSeconds() {
            return this.evaluationIntervalInSeconds;
        }

        public final void setEvaluationIntervalInSeconds(Integer evaluationIntervalInSeconds) {
            this.evaluationIntervalInSeconds = evaluationIntervalInSeconds;
        }

        @Override
        public final Builder evaluationIntervalInSeconds(Integer evaluationIntervalInSeconds) {
            this.evaluationIntervalInSeconds = evaluationIntervalInSeconds;
            return this;
        }

        public final AnomalyDetectorMissingDataAction.Builder getMissingDataAction() {
            return this.missingDataAction != null ? this.missingDataAction.toBuilder() : null;
        }

        public final void setMissingDataAction(AnomalyDetectorMissingDataAction.BuilderImpl missingDataAction) {
            this.missingDataAction = missingDataAction != null ? missingDataAction.build() : null;
        }

        @Override
        public final Builder missingDataAction(AnomalyDetectorMissingDataAction missingDataAction) {
            this.missingDataAction = missingDataAction;
            return this;
        }

        public final AnomalyDetectorConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AnomalyDetectorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AnomalyDetectorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Map<String, String> getLabels() {
            if (this.labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = PrometheusMetricLabelMapCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = PrometheusMetricLabelMapCopier.copy(labels);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAnomalyDetectorRequest build() {
            return new PutAnomalyDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmpRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAnomalyDetectorRequest> {
        public Builder workspaceId(String var1);

        public Builder anomalyDetectorId(String var1);

        public Builder evaluationIntervalInSeconds(Integer var1);

        public Builder missingDataAction(AnomalyDetectorMissingDataAction var1);

        default public Builder missingDataAction(Consumer<AnomalyDetectorMissingDataAction.Builder> missingDataAction) {
            return this.missingDataAction((AnomalyDetectorMissingDataAction)((AnomalyDetectorMissingDataAction.Builder)AnomalyDetectorMissingDataAction.builder().applyMutation(missingDataAction)).build());
        }

        public Builder configuration(AnomalyDetectorConfiguration var1);

        default public Builder configuration(Consumer<AnomalyDetectorConfiguration.Builder> configuration) {
            return this.configuration((AnomalyDetectorConfiguration)((AnomalyDetectorConfiguration.Builder)AnomalyDetectorConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder labels(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

