/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amp.model.AmpResponse;
import software.amazon.awssdk.services.amp.model.AnomalyDetectorDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnomalyDetectorResponse
extends AmpResponse
implements ToCopyableBuilder<Builder, DescribeAnomalyDetectorResponse> {
    private static final SdkField<AnomalyDetectorDescription> ANOMALY_DETECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("anomalyDetector").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::anomalyDetector)).setter(DescribeAnomalyDetectorResponse.setter(Builder::anomalyDetector)).constructor(AnomalyDetectorDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAnomalyDetectorResponse.memberNameToFieldInitializer();
    private final AnomalyDetectorDescription anomalyDetector;

    private DescribeAnomalyDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetector = builder.anomalyDetector;
    }

    public final AnomalyDetectorDescription anomalyDetector() {
        return this.anomalyDetector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectorResponse)) {
            return false;
        }
        DescribeAnomalyDetectorResponse other = (DescribeAnomalyDetectorResponse)((Object)obj);
        return Objects.equals(this.anomalyDetector(), other.anomalyDetector());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAnomalyDetectorResponse").add("AnomalyDetector", (Object)this.anomalyDetector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalyDetector": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<AnomalyDetectorDescription>> map = new HashMap<String, SdkField<AnomalyDetectorDescription>>();
        map.put("anomalyDetector", ANOMALY_DETECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectorResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpResponse.BuilderImpl
    implements Builder {
        private AnomalyDetectorDescription anomalyDetector;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectorResponse model) {
            super(model);
            this.anomalyDetector(model.anomalyDetector);
        }

        public final AnomalyDetectorDescription.Builder getAnomalyDetector() {
            return this.anomalyDetector != null ? this.anomalyDetector.toBuilder() : null;
        }

        public final void setAnomalyDetector(AnomalyDetectorDescription.BuilderImpl anomalyDetector) {
            this.anomalyDetector = anomalyDetector != null ? anomalyDetector.build() : null;
        }

        @Override
        public final Builder anomalyDetector(AnomalyDetectorDescription anomalyDetector) {
            this.anomalyDetector = anomalyDetector;
            return this;
        }

        @Override
        public DescribeAnomalyDetectorResponse build() {
            return new DescribeAnomalyDetectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmpResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnomalyDetectorResponse> {
        public Builder anomalyDetector(AnomalyDetectorDescription var1);

        default public Builder anomalyDetector(Consumer<AnomalyDetectorDescription.Builder> anomalyDetector) {
            return this.anomalyDetector((AnomalyDetectorDescription)((AnomalyDetectorDescription.Builder)AnomalyDetectorDescription.builder().applyMutation(anomalyDetector)).build());
        }
    }
}

