/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.AmpRequest;
import software.amazon.awssdk.services.amp.model.AnomalyDetectorConfiguration;
import software.amazon.awssdk.services.amp.model.AnomalyDetectorMissingDataAction;
import software.amazon.awssdk.services.amp.model.CreateAnomalyDetectorRequestLabelsMapCopier;
import software.amazon.awssdk.services.amp.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnomalyDetectorRequest
extends AmpRequest
implements ToCopyableBuilder<Builder, CreateAnomalyDetectorRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::workspaceId)).setter(CreateAnomalyDetectorRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::alias)).setter(CreateAnomalyDetectorRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<Integer> EVALUATION_INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("evaluationIntervalInSeconds").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::evaluationIntervalInSeconds)).setter(CreateAnomalyDetectorRequest.setter(Builder::evaluationIntervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationIntervalInSeconds").build()}).build();
    private static final SdkField<AnomalyDetectorMissingDataAction> MISSING_DATA_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("missingDataAction").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::missingDataAction)).setter(CreateAnomalyDetectorRequest.setter(Builder::missingDataAction)).constructor(AnomalyDetectorMissingDataAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingDataAction").build()}).build();
    private static final SdkField<AnomalyDetectorConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::configuration)).setter(CreateAnomalyDetectorRequest.setter(Builder::configuration)).constructor(AnomalyDetectorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("labels").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::labels)).setter(CreateAnomalyDetectorRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::clientToken)).setter(CreateAnomalyDetectorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAnomalyDetectorRequest.getter(CreateAnomalyDetectorRequest::tags)).setter(CreateAnomalyDetectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, ALIAS_FIELD, EVALUATION_INTERVAL_IN_SECONDS_FIELD, MISSING_DATA_ACTION_FIELD, CONFIGURATION_FIELD, LABELS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAnomalyDetectorRequest.memberNameToFieldInitializer();
    private final String workspaceId;
    private final String alias;
    private final Integer evaluationIntervalInSeconds;
    private final AnomalyDetectorMissingDataAction missingDataAction;
    private final AnomalyDetectorConfiguration configuration;
    private final Map<String, String> labels;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.alias = builder.alias;
        this.evaluationIntervalInSeconds = builder.evaluationIntervalInSeconds;
        this.missingDataAction = builder.missingDataAction;
        this.configuration = builder.configuration;
        this.labels = builder.labels;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String alias() {
        return this.alias;
    }

    public final Integer evaluationIntervalInSeconds() {
        return this.evaluationIntervalInSeconds;
    }

    public final AnomalyDetectorMissingDataAction missingDataAction() {
        return this.missingDataAction;
    }

    public final AnomalyDetectorConfiguration configuration() {
        return this.configuration;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> labels() {
        return this.labels;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingDataAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalyDetectorRequest)) {
            return false;
        }
        CreateAnomalyDetectorRequest other = (CreateAnomalyDetectorRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.evaluationIntervalInSeconds(), other.evaluationIntervalInSeconds()) && Objects.equals(this.missingDataAction(), other.missingDataAction()) && Objects.equals(this.configuration(), other.configuration()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnomalyDetectorRequest").add("WorkspaceId", (Object)this.workspaceId()).add("Alias", (Object)this.alias()).add("EvaluationIntervalInSeconds", (Object)this.evaluationIntervalInSeconds()).add("MissingDataAction", (Object)this.missingDataAction()).add("Configuration", (Object)this.configuration()).add("Labels", this.hasLabels() ? this.labels() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "evaluationIntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.evaluationIntervalInSeconds()));
            }
            case "missingDataAction": {
                return Optional.ofNullable(clazz.cast(this.missingDataAction()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("evaluationIntervalInSeconds", EVALUATION_INTERVAL_IN_SECONDS_FIELD);
        map.put("missingDataAction", MISSING_DATA_ACTION_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("labels", LABELS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((CreateAnomalyDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String alias;
        private Integer evaluationIntervalInSeconds;
        private AnomalyDetectorMissingDataAction missingDataAction;
        private AnomalyDetectorConfiguration configuration;
        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalyDetectorRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.alias(model.alias);
            this.evaluationIntervalInSeconds(model.evaluationIntervalInSeconds);
            this.missingDataAction(model.missingDataAction);
            this.configuration(model.configuration);
            this.labels(model.labels);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final Integer getEvaluationIntervalInSeconds() {
            return this.evaluationIntervalInSeconds;
        }

        public final void setEvaluationIntervalInSeconds(Integer evaluationIntervalInSeconds) {
            this.evaluationIntervalInSeconds = evaluationIntervalInSeconds;
        }

        @Override
        public final Builder evaluationIntervalInSeconds(Integer evaluationIntervalInSeconds) {
            this.evaluationIntervalInSeconds = evaluationIntervalInSeconds;
            return this;
        }

        public final AnomalyDetectorMissingDataAction.Builder getMissingDataAction() {
            return this.missingDataAction != null ? this.missingDataAction.toBuilder() : null;
        }

        public final void setMissingDataAction(AnomalyDetectorMissingDataAction.BuilderImpl missingDataAction) {
            this.missingDataAction = missingDataAction != null ? missingDataAction.build() : null;
        }

        @Override
        public final Builder missingDataAction(AnomalyDetectorMissingDataAction missingDataAction) {
            this.missingDataAction = missingDataAction;
            return this;
        }

        public final AnomalyDetectorConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AnomalyDetectorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AnomalyDetectorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Map<String, String> getLabels() {
            if (this.labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = CreateAnomalyDetectorRequestLabelsMapCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = CreateAnomalyDetectorRequestLabelsMapCopier.copy(labels);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnomalyDetectorRequest build() {
            return new CreateAnomalyDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmpRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnomalyDetectorRequest> {
        public Builder workspaceId(String var1);

        public Builder alias(String var1);

        public Builder evaluationIntervalInSeconds(Integer var1);

        public Builder missingDataAction(AnomalyDetectorMissingDataAction var1);

        default public Builder missingDataAction(Consumer<AnomalyDetectorMissingDataAction.Builder> missingDataAction) {
            return this.missingDataAction((AnomalyDetectorMissingDataAction)((AnomalyDetectorMissingDataAction.Builder)AnomalyDetectorMissingDataAction.builder().applyMutation(missingDataAction)).build());
        }

        public Builder configuration(AnomalyDetectorConfiguration var1);

        default public Builder configuration(Consumer<AnomalyDetectorConfiguration.Builder> configuration) {
            return this.configuration((AnomalyDetectorConfiguration)((AnomalyDetectorConfiguration.Builder)AnomalyDetectorConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder labels(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

