/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for threshold settings that determine when values near expected values should be ignored during anomaly
 * detection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IgnoreNearExpected implements SdkPojo, Serializable,
        ToCopyableBuilder<IgnoreNearExpected.Builder, IgnoreNearExpected> {
    private static final SdkField<Double> AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("amount")
            .getter(getter(IgnoreNearExpected::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final SdkField<Double> RATIO_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("ratio")
            .getter(getter(IgnoreNearExpected::ratio)).setter(setter(Builder::ratio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ratio").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, RATIO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double amount;

    private final Double ratio;

    private final Type type;

    private IgnoreNearExpected(BuilderImpl builder) {
        this.amount = builder.amount;
        this.ratio = builder.ratio;
        this.type = builder.type;
    }

    /**
     * <p>
     * The absolute amount by which values can differ from expected values before being considered anomalous.
     * </p>
     * 
     * @return The absolute amount by which values can differ from expected values before being considered anomalous.
     */
    public final Double amount() {
        return amount;
    }

    /**
     * <p>
     * The ratio by which values can differ from expected values before being considered anomalous.
     * </p>
     * 
     * @return The ratio by which values can differ from expected values before being considered anomalous.
     */
    public final Double ratio() {
        return ratio;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(ratio());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IgnoreNearExpected)) {
            return false;
        }
        IgnoreNearExpected other = (IgnoreNearExpected) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(ratio(), other.ratio());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IgnoreNearExpected").add("Amount", amount()).add("Ratio", ratio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "ratio":
            return Optional.ofNullable(clazz.cast(ratio()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #amount()} initialized to the given value.
     *
     * <p>
     * The absolute amount by which values can differ from expected values before being considered anomalous.
     * </p>
     * 
     * @param amount
     *        The absolute amount by which values can differ from expected values before being considered anomalous.
     */
    public static IgnoreNearExpected fromAmount(Double amount) {
        return builder().amount(amount).build();
    }

    /**
     * Create an instance of this class with {@link #ratio()} initialized to the given value.
     *
     * <p>
     * The ratio by which values can differ from expected values before being considered anomalous.
     * </p>
     * 
     * @param ratio
     *        The ratio by which values can differ from expected values before being considered anomalous.
     */
    public static IgnoreNearExpected fromRatio(Double ratio) {
        return builder().ratio(ratio).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amount", AMOUNT_FIELD);
        map.put("ratio", RATIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IgnoreNearExpected, T> g) {
        return obj -> g.apply((IgnoreNearExpected) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IgnoreNearExpected> {
        /**
         * <p>
         * The absolute amount by which values can differ from expected values before being considered anomalous.
         * </p>
         * 
         * @param amount
         *        The absolute amount by which values can differ from expected values before being considered anomalous.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * The ratio by which values can differ from expected values before being considered anomalous.
         * </p>
         * 
         * @param ratio
         *        The ratio by which values can differ from expected values before being considered anomalous.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ratio(Double ratio);
    }

    static final class BuilderImpl implements Builder {
        private Double amount;

        private Double ratio;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IgnoreNearExpected model) {
            amount(model.amount);
            ratio(model.ratio);
        }

        public final Double getAmount() {
            return amount;
        }

        public final void setAmount(Double amount) {
            Object oldValue = this.amount;
            this.amount = amount;
            handleUnionValueChange(Type.AMOUNT, oldValue, this.amount);
        }

        @Override
        public final Builder amount(Double amount) {
            Object oldValue = this.amount;
            this.amount = amount;
            handleUnionValueChange(Type.AMOUNT, oldValue, this.amount);
            return this;
        }

        public final Double getRatio() {
            return ratio;
        }

        public final void setRatio(Double ratio) {
            Object oldValue = this.ratio;
            this.ratio = ratio;
            handleUnionValueChange(Type.RATIO, oldValue, this.ratio);
        }

        @Override
        public final Builder ratio(Double ratio) {
            Object oldValue = this.ratio;
            this.ratio = ratio;
            handleUnionValueChange(Type.RATIO, oldValue, this.ratio);
            return this;
        }

        @Override
        public IgnoreNearExpected build() {
            return new IgnoreNearExpected(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see IgnoreNearExpected#type()
     */
    public enum Type {
        AMOUNT,

        RATIO,

        UNKNOWN_TO_SDK_VERSION
    }
}
