/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateLoggingConfiguration</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoggingConfigurationRequest extends AmpRequest implements
        ToCopyableBuilder<CreateLoggingConfigurationRequest.Builder, CreateLoggingConfigurationRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateLoggingConfigurationRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupArn").getter(getter(CreateLoggingConfigurationRequest::logGroupArn))
            .setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateLoggingConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            LOG_GROUP_ARN_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workspaceId;

    private final String logGroupArn;

    private final String clientToken;

    private CreateLoggingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.logGroupArn = builder.logGroupArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the workspace to create the logging configuration for.
     * </p>
     * 
     * @return The ID of the workspace to create the logging configuration for.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist
     * prior to calling this operation.
     * </p>
     * 
     * @return The ARN of the CloudWatch log group to which the vended log data will be published. This log group must
     *         exist prior to calling this operation.
     */
    public final String logGroupArn() {
        return logGroupArn;
    }

    /**
     * <p>
     * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     * </p>
     * 
     * @return A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoggingConfigurationRequest)) {
            return false;
        }
        CreateLoggingConfigurationRequest other = (CreateLoggingConfigurationRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(logGroupArn(), other.logGroupArn())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLoggingConfigurationRequest").add("WorkspaceId", workspaceId())
                .add("LogGroupArn", logGroupArn()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "logGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        map.put("logGroupArn", LOG_GROUP_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLoggingConfigurationRequest, T> g) {
        return obj -> g.apply((CreateLoggingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmpRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLoggingConfigurationRequest> {
        /**
         * <p>
         * The ID of the workspace to create the logging configuration for.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace to create the logging configuration for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist
         * prior to calling this operation.
         * </p>
         * 
         * @param logGroupArn
         *        The ARN of the CloudWatch log group to which the vended log data will be published. This log group
         *        must exist prior to calling this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);

        /**
         * <p>
         * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmpRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private String logGroupArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoggingConfigurationRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            logGroupArn(model.logGroupArn);
            clientToken(model.clientToken);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoggingConfigurationRequest build() {
            return new CreateLoggingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
