/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amp.AmpAsyncClient;
import software.amazon.awssdk.services.amp.internal.UserAgentUtils;
import software.amazon.awssdk.services.amp.model.ListScrapersRequest;
import software.amazon.awssdk.services.amp.model.ListScrapersResponse;
import software.amazon.awssdk.services.amp.model.ScraperSummary;

public class ListScrapersPublisher
implements SdkPublisher<ListScrapersResponse> {
    private final AmpAsyncClient client;
    private final ListScrapersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScrapersPublisher(AmpAsyncClient client, ListScrapersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScrapersPublisher(AmpAsyncClient client, ListScrapersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScrapersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScrapersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScraperSummary> scrapers() {
        Function<ListScrapersResponse, Iterator> getIterator = response -> {
            if (response != null && response.scrapers() != null) {
                return response.scrapers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScrapersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScrapersResponseFetcher
    implements AsyncPageFetcher<ListScrapersResponse> {
        private ListScrapersResponseFetcher() {
        }

        public boolean hasNextPage(ListScrapersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScrapersResponse> nextPage(ListScrapersResponse previousPage) {
            if (previousPage == null) {
                return ListScrapersPublisher.this.client.listScrapers(ListScrapersPublisher.this.firstRequest);
            }
            return ListScrapersPublisher.this.client.listScrapers((ListScrapersRequest)((Object)ListScrapersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

