/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.aiops.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.aiops.model.AiOpsRequest;
import software.amazon.awssdk.services.aiops.model.ChatbotNotificationChannelCopier;
import software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration;
import software.amazon.awssdk.services.aiops.model.CrossAccountConfigurationsCopier;
import software.amazon.awssdk.services.aiops.model.EncryptionConfiguration;
import software.amazon.awssdk.services.aiops.model.TagKeyBoundariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInvestigationGroupRequest
extends AiOpsRequest
implements ToCopyableBuilder<Builder, UpdateInvestigationGroupRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateInvestigationGroupRequest.getter(UpdateInvestigationGroupRequest::identifier)).setter(UpdateInvestigationGroupRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateInvestigationGroupRequest.getter(UpdateInvestigationGroupRequest::roleArn)).setter(UpdateInvestigationGroupRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(UpdateInvestigationGroupRequest.getter(UpdateInvestigationGroupRequest::encryptionConfiguration)).setter(UpdateInvestigationGroupRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<List<String>> TAG_KEY_BOUNDARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagKeyBoundaries").getter(UpdateInvestigationGroupRequest.getter(UpdateInvestigationGroupRequest::tagKeyBoundaries)).setter(UpdateInvestigationGroupRequest.setter(Builder::tagKeyBoundaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKeyBoundaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> CHATBOT_NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("chatbotNotificationChannel").getter(UpdateInvestigationGroupRequest.getter(UpdateInvestigationGroupRequest::chatbotNotificationChannel)).setter(UpdateInvestigationGroupRequest.setter(Builder::chatbotNotificationChannel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatbotNotificationChannel").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isCloudTrailEventHistoryEnabled").getter(UpdateInvestigationGroupRequest.getter(UpdateInvestigationGroupRequest::isCloudTrailEventHistoryEnabled)).setter(UpdateInvestigationGroupRequest.setter(Builder::isCloudTrailEventHistoryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCloudTrailEventHistoryEnabled").build()}).build();
    private static final SdkField<List<CrossAccountConfiguration>> CROSS_ACCOUNT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("crossAccountConfigurations").getter(UpdateInvestigationGroupRequest.getter(UpdateInvestigationGroupRequest::crossAccountConfigurations)).setter(UpdateInvestigationGroupRequest.setter(Builder::crossAccountConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrossAccountConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, ROLE_ARN_FIELD, ENCRYPTION_CONFIGURATION_FIELD, TAG_KEY_BOUNDARIES_FIELD, CHATBOT_NOTIFICATION_CHANNEL_FIELD, IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD, CROSS_ACCOUNT_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateInvestigationGroupRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final String roleArn;
    private final EncryptionConfiguration encryptionConfiguration;
    private final List<String> tagKeyBoundaries;
    private final Map<String, List<String>> chatbotNotificationChannel;
    private final Boolean isCloudTrailEventHistoryEnabled;
    private final List<CrossAccountConfiguration> crossAccountConfigurations;

    private UpdateInvestigationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.roleArn = builder.roleArn;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.tagKeyBoundaries = builder.tagKeyBoundaries;
        this.chatbotNotificationChannel = builder.chatbotNotificationChannel;
        this.isCloudTrailEventHistoryEnabled = builder.isCloudTrailEventHistoryEnabled;
        this.crossAccountConfigurations = builder.crossAccountConfigurations;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final boolean hasTagKeyBoundaries() {
        return this.tagKeyBoundaries != null && !(this.tagKeyBoundaries instanceof SdkAutoConstructList);
    }

    public final List<String> tagKeyBoundaries() {
        return this.tagKeyBoundaries;
    }

    public final boolean hasChatbotNotificationChannel() {
        return this.chatbotNotificationChannel != null && !(this.chatbotNotificationChannel instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> chatbotNotificationChannel() {
        return this.chatbotNotificationChannel;
    }

    public final Boolean isCloudTrailEventHistoryEnabled() {
        return this.isCloudTrailEventHistoryEnabled;
    }

    public final boolean hasCrossAccountConfigurations() {
        return this.crossAccountConfigurations != null && !(this.crossAccountConfigurations instanceof SdkAutoConstructList);
    }

    public final List<CrossAccountConfiguration> crossAccountConfigurations() {
        return this.crossAccountConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagKeyBoundaries() ? this.tagKeyBoundaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChatbotNotificationChannel() ? this.chatbotNotificationChannel() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isCloudTrailEventHistoryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossAccountConfigurations() ? this.crossAccountConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInvestigationGroupRequest)) {
            return false;
        }
        UpdateInvestigationGroupRequest other = (UpdateInvestigationGroupRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && this.hasTagKeyBoundaries() == other.hasTagKeyBoundaries() && Objects.equals(this.tagKeyBoundaries(), other.tagKeyBoundaries()) && this.hasChatbotNotificationChannel() == other.hasChatbotNotificationChannel() && Objects.equals(this.chatbotNotificationChannel(), other.chatbotNotificationChannel()) && Objects.equals(this.isCloudTrailEventHistoryEnabled(), other.isCloudTrailEventHistoryEnabled()) && this.hasCrossAccountConfigurations() == other.hasCrossAccountConfigurations() && Objects.equals(this.crossAccountConfigurations(), other.crossAccountConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInvestigationGroupRequest").add("Identifier", (Object)this.identifier()).add("RoleArn", (Object)this.roleArn()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("TagKeyBoundaries", this.hasTagKeyBoundaries() ? this.tagKeyBoundaries() : null).add("ChatbotNotificationChannel", this.hasChatbotNotificationChannel() ? this.chatbotNotificationChannel() : null).add("IsCloudTrailEventHistoryEnabled", (Object)this.isCloudTrailEventHistoryEnabled()).add("CrossAccountConfigurations", this.hasCrossAccountConfigurations() ? this.crossAccountConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "tagKeyBoundaries": {
                return Optional.ofNullable(clazz.cast(this.tagKeyBoundaries()));
            }
            case "chatbotNotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.chatbotNotificationChannel()));
            }
            case "isCloudTrailEventHistoryEnabled": {
                return Optional.ofNullable(clazz.cast(this.isCloudTrailEventHistoryEnabled()));
            }
            case "crossAccountConfigurations": {
                return Optional.ofNullable(clazz.cast(this.crossAccountConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("tagKeyBoundaries", TAG_KEY_BOUNDARIES_FIELD);
        map.put("chatbotNotificationChannel", CHATBOT_NOTIFICATION_CHANNEL_FIELD);
        map.put("isCloudTrailEventHistoryEnabled", IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD);
        map.put("crossAccountConfigurations", CROSS_ACCOUNT_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInvestigationGroupRequest, T> g) {
        return obj -> g.apply((UpdateInvestigationGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AiOpsRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String roleArn;
        private EncryptionConfiguration encryptionConfiguration;
        private List<String> tagKeyBoundaries = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> chatbotNotificationChannel = DefaultSdkAutoConstructMap.getInstance();
        private Boolean isCloudTrailEventHistoryEnabled;
        private List<CrossAccountConfiguration> crossAccountConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInvestigationGroupRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.roleArn(model.roleArn);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.tagKeyBoundaries(model.tagKeyBoundaries);
            this.chatbotNotificationChannel(model.chatbotNotificationChannel);
            this.isCloudTrailEventHistoryEnabled(model.isCloudTrailEventHistoryEnabled);
            this.crossAccountConfigurations(model.crossAccountConfigurations);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Collection<String> getTagKeyBoundaries() {
            if (this.tagKeyBoundaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagKeyBoundaries;
        }

        public final void setTagKeyBoundaries(Collection<String> tagKeyBoundaries) {
            this.tagKeyBoundaries = TagKeyBoundariesCopier.copy(tagKeyBoundaries);
        }

        @Override
        public final Builder tagKeyBoundaries(Collection<String> tagKeyBoundaries) {
            this.tagKeyBoundaries = TagKeyBoundariesCopier.copy(tagKeyBoundaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyBoundaries(String ... tagKeyBoundaries) {
            this.tagKeyBoundaries(Arrays.asList(tagKeyBoundaries));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getChatbotNotificationChannel() {
            if (this.chatbotNotificationChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.chatbotNotificationChannel;
        }

        public final void setChatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel) {
            this.chatbotNotificationChannel = ChatbotNotificationChannelCopier.copy(chatbotNotificationChannel);
        }

        @Override
        public final Builder chatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel) {
            this.chatbotNotificationChannel = ChatbotNotificationChannelCopier.copy(chatbotNotificationChannel);
            return this;
        }

        public final Boolean getIsCloudTrailEventHistoryEnabled() {
            return this.isCloudTrailEventHistoryEnabled;
        }

        public final void setIsCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
        }

        @Override
        public final Builder isCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
            return this;
        }

        public final List<CrossAccountConfiguration.Builder> getCrossAccountConfigurations() {
            List<CrossAccountConfiguration.Builder> result = CrossAccountConfigurationsCopier.copyToBuilder(this.crossAccountConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossAccountConfigurations(Collection<CrossAccountConfiguration.BuilderImpl> crossAccountConfigurations) {
            this.crossAccountConfigurations = CrossAccountConfigurationsCopier.copyFromBuilder(crossAccountConfigurations);
        }

        @Override
        public final Builder crossAccountConfigurations(Collection<CrossAccountConfiguration> crossAccountConfigurations) {
            this.crossAccountConfigurations = CrossAccountConfigurationsCopier.copy(crossAccountConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountConfigurations(CrossAccountConfiguration ... crossAccountConfigurations) {
            this.crossAccountConfigurations(Arrays.asList(crossAccountConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountConfigurations(Consumer<CrossAccountConfiguration.Builder> ... crossAccountConfigurations) {
            this.crossAccountConfigurations(Stream.of(crossAccountConfigurations).map(c -> (CrossAccountConfiguration)((CrossAccountConfiguration.Builder)CrossAccountConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInvestigationGroupRequest build() {
            return new UpdateInvestigationGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AiOpsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInvestigationGroupRequest> {
        public Builder identifier(String var1);

        public Builder roleArn(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder tagKeyBoundaries(Collection<String> var1);

        public Builder tagKeyBoundaries(String ... var1);

        public Builder chatbotNotificationChannel(Map<String, ? extends Collection<String>> var1);

        public Builder isCloudTrailEventHistoryEnabled(Boolean var1);

        public Builder crossAccountConfigurations(Collection<CrossAccountConfiguration> var1);

        public Builder crossAccountConfigurations(CrossAccountConfiguration ... var1);

        public Builder crossAccountConfigurations(Consumer<CrossAccountConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

