/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCertificateAuthorityAuditReportResponse
extends AcmPcaResponse
implements ToCopyableBuilder<Builder, CreateCertificateAuthorityAuditReportResponse> {
    private static final SdkField<String> AUDIT_REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditReportId").getter(CreateCertificateAuthorityAuditReportResponse.getter(CreateCertificateAuthorityAuditReportResponse::auditReportId)).setter(CreateCertificateAuthorityAuditReportResponse.setter(Builder::auditReportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditReportId").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Key").getter(CreateCertificateAuthorityAuditReportResponse.getter(CreateCertificateAuthorityAuditReportResponse::s3Key)).setter(CreateCertificateAuthorityAuditReportResponse.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_REPORT_ID_FIELD, S3_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AuditReportId", AUDIT_REPORT_ID_FIELD);
            this.put("S3Key", S3_KEY_FIELD);
        }
    });
    private final String auditReportId;
    private final String s3Key;

    private CreateCertificateAuthorityAuditReportResponse(BuilderImpl builder) {
        super(builder);
        this.auditReportId = builder.auditReportId;
        this.s3Key = builder.s3Key;
    }

    public final String auditReportId() {
        return this.auditReportId;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.auditReportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateAuthorityAuditReportResponse)) {
            return false;
        }
        CreateCertificateAuthorityAuditReportResponse other = (CreateCertificateAuthorityAuditReportResponse)((Object)obj);
        return Objects.equals(this.auditReportId(), other.auditReportId()) && Objects.equals(this.s3Key(), other.s3Key());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCertificateAuthorityAuditReportResponse").add("AuditReportId", (Object)this.auditReportId()).add("S3Key", (Object)this.s3Key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuditReportId": {
                return Optional.ofNullable(clazz.cast(this.auditReportId()));
            }
            case "S3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateAuthorityAuditReportResponse, T> g) {
        return obj -> g.apply((CreateCertificateAuthorityAuditReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaResponse.BuilderImpl
    implements Builder {
        private String auditReportId;
        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateAuthorityAuditReportResponse model) {
            super(model);
            this.auditReportId(model.auditReportId);
            this.s3Key(model.s3Key);
        }

        public final String getAuditReportId() {
            return this.auditReportId;
        }

        public final void setAuditReportId(String auditReportId) {
            this.auditReportId = auditReportId;
        }

        @Override
        public final Builder auditReportId(String auditReportId) {
            this.auditReportId = auditReportId;
            return this;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        @Override
        public CreateCertificateAuthorityAuditReportResponse build() {
            return new CreateCertificateAuthorityAuditReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AcmPcaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCertificateAuthorityAuditReportResponse> {
        public Builder auditReportId(String var1);

        public Builder s3Key(String var1);
    }
}

