/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acmpca.AcmPcaAsyncClient;
import software.amazon.awssdk.services.acmpca.AcmPcaAsyncClientBuilder;
import software.amazon.awssdk.services.acmpca.AcmPcaServiceClientConfiguration;
import software.amazon.awssdk.services.acmpca.DefaultAcmPcaAsyncClient;
import software.amazon.awssdk.services.acmpca.DefaultAcmPcaBaseClientBuilder;
import software.amazon.awssdk.services.acmpca.endpoints.AcmPcaEndpointProvider;

@SdkInternalApi
final class DefaultAcmPcaAsyncClientBuilder
extends DefaultAcmPcaBaseClientBuilder<AcmPcaAsyncClientBuilder, AcmPcaAsyncClient>
implements AcmPcaAsyncClientBuilder {
    DefaultAcmPcaAsyncClientBuilder() {
    }

    @Override
    public DefaultAcmPcaAsyncClientBuilder endpointProvider(AcmPcaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AcmPcaAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAcmPcaAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AcmPcaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAcmPcaAsyncClient client = new DefaultAcmPcaAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AcmPcaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AcmPcaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

